/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DiscoveryNode
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final String ephemeralId;
    private final String id;
    private final String name;
    private final String transportAddress;
    public static final JsonpDeserializer<DiscoveryNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiscoveryNode::setupDiscoveryNodeDeserializer, Builder::build);

    public DiscoveryNode(Builder builder) {
        this.attributes = ModelTypeHelper.unmodifiableNonNull(builder.attributes, "attributes");
        this.ephemeralId = Objects.requireNonNull(builder.ephemeralId, "ephemeral_id");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.transportAddress = Objects.requireNonNull(builder.transportAddress, "transport_address");
    }

    public DiscoveryNode(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String ephemeralId() {
        return this.ephemeralId;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, String> item0 : this.attributes.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeEnd();
        generator.writeKey("ephemeral_id");
        generator.write(this.ephemeralId);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    protected static void setupDiscoveryNodeDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
        op.add(Builder::ephemeralId, JsonpDeserializer.stringDeserializer(), "ephemeral_id", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DiscoveryNode> {
        private Map<String, String> attributes;
        private String ephemeralId;
        private String id;
        private String name;
        private String transportAddress;

        public Builder attributes(Map<String, String> value) {
            this.attributes = value;
            return this;
        }

        public Builder putAttributes(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder ephemeralId(String value) {
            this.ephemeralId = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Override
        public DiscoveryNode build() {
            return new DiscoveryNode(this);
        }
    }
}

