/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeAnalyticsFieldSelection
implements JsonpSerializable {
    private final boolean isIncluded;
    private final boolean isRequired;
    @Nullable
    private final String featureType;
    private final List<String> mappingTypes;
    private final String name;
    @Nullable
    private final String reason;
    public static final JsonpDeserializer<DataframeAnalyticsFieldSelection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsFieldSelection::setupDataframeAnalyticsFieldSelectionDeserializer, Builder::build);

    public DataframeAnalyticsFieldSelection(Builder builder) {
        this.isIncluded = Objects.requireNonNull(builder.isIncluded, "is_included");
        this.isRequired = Objects.requireNonNull(builder.isRequired, "is_required");
        this.featureType = builder.featureType;
        this.mappingTypes = ModelTypeHelper.unmodifiableNonNull(builder.mappingTypes, "mapping_types");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.reason = builder.reason;
    }

    public DataframeAnalyticsFieldSelection(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    @Nullable
    public String featureType() {
        return this.featureType;
    }

    public List<String> mappingTypes() {
        return this.mappingTypes;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("is_included");
        generator.write(this.isIncluded);
        generator.writeKey("is_required");
        generator.write(this.isRequired);
        if (this.featureType != null) {
            generator.writeKey("feature_type");
            generator.write(this.featureType);
        }
        generator.writeKey("mapping_types");
        generator.writeStartArray();
        for (String item0 : this.mappingTypes) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("name");
        generator.write(this.name);
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
    }

    protected static void setupDataframeAnalyticsFieldSelectionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::isIncluded, JsonpDeserializer.booleanDeserializer(), "is_included", new String[0]);
        op.add(Builder::isRequired, JsonpDeserializer.booleanDeserializer(), "is_required", new String[0]);
        op.add(Builder::featureType, JsonpDeserializer.stringDeserializer(), "feature_type", new String[0]);
        op.add(Builder::mappingTypes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "mapping_types", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalyticsFieldSelection> {
        private Boolean isIncluded;
        private Boolean isRequired;
        @Nullable
        private String featureType;
        private List<String> mappingTypes;
        private String name;
        @Nullable
        private String reason;

        public Builder isIncluded(boolean value) {
            this.isIncluded = value;
            return this;
        }

        public Builder isRequired(boolean value) {
            this.isRequired = value;
            return this;
        }

        public Builder featureType(@Nullable String value) {
            this.featureType = value;
            return this;
        }

        public Builder mappingTypes(List<String> value) {
            this.mappingTypes = value;
            return this;
        }

        public Builder mappingTypes(String ... value) {
            this.mappingTypes = Arrays.asList(value);
            return this;
        }

        public Builder addMappingTypes(String value) {
            if (this.mappingTypes == null) {
                this.mappingTypes = new ArrayList<String>();
            }
            this.mappingTypes.add(value);
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Override
        public DataframeAnalyticsFieldSelection build() {
            return new DataframeAnalyticsFieldSelection(this);
        }
    }
}

