/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.analysis.CharFilter;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.Tokenizer;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CategorizationAnalyzer
implements JsonpSerializable {
    @Nullable
    private final List<CharFilter> charFilter;
    @Nullable
    private final List<TokenFilter> filter;
    @Nullable
    private final Tokenizer tokenizer;
    public static final JsonpDeserializer<CategorizationAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CategorizationAnalyzer::setupCategorizationAnalyzerDeserializer, Builder::build);

    public CategorizationAnalyzer(Builder builder) {
        this.charFilter = ModelTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ModelTypeHelper.unmodifiable(builder.filter);
        this.tokenizer = builder.tokenizer;
    }

    public CategorizationAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<CharFilter> charFilter() {
        return this.charFilter;
    }

    @Nullable
    public List<TokenFilter> filter() {
        return this.filter;
    }

    @Nullable
    public Tokenizer tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.charFilter != null) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (CharFilter charFilter : this.charFilter) {
                charFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (TokenFilter tokenFilter : this.filter) {
                tokenFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    protected static void setupCategorizationAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(CharFilter._DESERIALIZER), "char_filter", new String[0]);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(TokenFilter._DESERIALIZER), "filter", new String[0]);
        op.add(Builder::tokenizer, Tokenizer._DESERIALIZER, "tokenizer", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CategorizationAnalyzer> {
        @Nullable
        private List<CharFilter> charFilter;
        @Nullable
        private List<TokenFilter> filter;
        @Nullable
        private Tokenizer tokenizer;

        public Builder charFilter(@Nullable List<CharFilter> value) {
            this.charFilter = value;
            return this;
        }

        public Builder charFilter(CharFilter ... value) {
            this.charFilter = Arrays.asList(value);
            return this;
        }

        public Builder addCharFilter(CharFilter value) {
            if (this.charFilter == null) {
                this.charFilter = new ArrayList<CharFilter>();
            }
            this.charFilter.add(value);
            return this;
        }

        public Builder charFilter(Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(fn.apply(new CharFilter.Builder()).build());
        }

        public Builder addCharFilter(Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.addCharFilter(fn.apply(new CharFilter.Builder()).build());
        }

        public Builder filter(@Nullable List<TokenFilter> value) {
            this.filter = value;
            return this;
        }

        public Builder filter(TokenFilter ... value) {
            this.filter = Arrays.asList(value);
            return this;
        }

        public Builder addFilter(TokenFilter value) {
            if (this.filter == null) {
                this.filter = new ArrayList<TokenFilter>();
            }
            this.filter.add(value);
            return this;
        }

        public Builder filter(Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(fn.apply(new TokenFilter.Builder()).build());
        }

        public Builder addFilter(Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.addFilter(fn.apply(new TokenFilter.Builder()).build());
        }

        public Builder tokenizer(@Nullable Tokenizer value) {
            this.tokenizer = value;
            return this;
        }

        public Builder tokenizer(Function<Tokenizer.Builder, ObjectBuilder<Tokenizer>> fn) {
            return this.tokenizer(fn.apply(new Tokenizer.Builder()).build());
        }

        @Override
        public CategorizationAnalyzer build() {
            return new CategorizationAnalyzer(this);
        }
    }
}

