/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ForeachProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    private final Processor processor;
    public static final JsonpDeserializer<ForeachProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForeachProcessor::setupForeachProcessorDeserializer, Builder::build);

    public ForeachProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.processor = Objects.requireNonNull(builder.processor, "processor");
    }

    public ForeachProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "foreach";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public Processor processor() {
        return this.processor;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        generator.writeKey("processor");
        this.processor.serialize(generator, mapper);
    }

    protected static void setupForeachProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::processor, Processor._DESERIALIZER, "processor", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ForeachProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        private Processor processor;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder processor(Processor value) {
            this.processor = value;
            return this;
        }

        public Builder processor(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processor(fn.apply(new Processor.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForeachProcessor build() {
            return new ForeachProcessor(this);
        }
    }
}

