/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CsvProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final JsonData emptyValue;
    @Nullable
    private final String description;
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final String quote;
    @Nullable
    private final String separator;
    private final List<String> targetFields;
    private final boolean trim;
    public static final JsonpDeserializer<CsvProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CsvProcessor::setupCsvProcessorDeserializer, Builder::build);

    public CsvProcessor(Builder builder) {
        super(builder);
        this.emptyValue = Objects.requireNonNull(builder.emptyValue, "empty_value");
        this.description = builder.description;
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.quote = builder.quote;
        this.separator = builder.separator;
        this.targetFields = ModelTypeHelper.unmodifiableNonNull(builder.targetFields, "target_fields");
        this.trim = Objects.requireNonNull(builder.trim, "trim");
    }

    public CsvProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "csv";
    }

    public JsonData emptyValue() {
        return this.emptyValue;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public String quote() {
        return this.quote;
    }

    @Nullable
    public String separator() {
        return this.separator;
    }

    public List<String> targetFields() {
        return this.targetFields;
    }

    public boolean trim() {
        return this.trim;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("empty_value");
        this.emptyValue.serialize(generator, mapper);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.quote != null) {
            generator.writeKey("quote");
            generator.write(this.quote);
        }
        if (this.separator != null) {
            generator.writeKey("separator");
            generator.write(this.separator);
        }
        generator.writeKey("target_fields");
        generator.writeStartArray();
        for (String item0 : this.targetFields) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("trim");
        generator.write(this.trim);
    }

    protected static void setupCsvProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::emptyValue, JsonData._DESERIALIZER, "empty_value", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::quote, JsonpDeserializer.stringDeserializer(), "quote", new String[0]);
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator", new String[0]);
        op.add(Builder::targetFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "target_fields", new String[0]);
        op.add(Builder::trim, JsonpDeserializer.booleanDeserializer(), "trim", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CsvProcessor> {
        private JsonData emptyValue;
        @Nullable
        private String description;
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private String quote;
        @Nullable
        private String separator;
        private List<String> targetFields;
        private Boolean trim;

        public Builder emptyValue(JsonData value) {
            this.emptyValue = value;
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder quote(@Nullable String value) {
            this.quote = value;
            return this;
        }

        public Builder separator(@Nullable String value) {
            this.separator = value;
            return this;
        }

        public Builder targetFields(List<String> value) {
            this.targetFields = value;
            return this;
        }

        public Builder targetFields(String ... value) {
            this.targetFields = Arrays.asList(value);
            return this;
        }

        public Builder addTargetFields(String value) {
            if (this.targetFields == null) {
                this.targetFields = new ArrayList<String>();
            }
            this.targetFields.add(value);
            return this;
        }

        public Builder trim(boolean value) {
            this.trim = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CsvProcessor build() {
            return new CsvProcessor(this);
        }
    }
}

