/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.elasticsearch.indices.segments.Segment;
import co.elastic.clients.elasticsearch.indices.segments.ShardSegmentRouting;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardsSegment
implements JsonpSerializable {
    private final int numCommittedSegments;
    private final ShardSegmentRouting routing;
    private final int numSearchSegments;
    private final Map<String, Segment> segments;
    public static final JsonpDeserializer<ShardsSegment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsSegment::setupShardsSegmentDeserializer, Builder::build);

    public ShardsSegment(Builder builder) {
        this.numCommittedSegments = Objects.requireNonNull(builder.numCommittedSegments, "num_committed_segments");
        this.routing = Objects.requireNonNull(builder.routing, "routing");
        this.numSearchSegments = Objects.requireNonNull(builder.numSearchSegments, "num_search_segments");
        this.segments = ModelTypeHelper.unmodifiableNonNull(builder.segments, "segments");
    }

    public ShardsSegment(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int numCommittedSegments() {
        return this.numCommittedSegments;
    }

    public ShardSegmentRouting routing() {
        return this.routing;
    }

    public int numSearchSegments() {
        return this.numSearchSegments;
    }

    public Map<String, Segment> segments() {
        return this.segments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("num_committed_segments");
        generator.write(this.numCommittedSegments);
        generator.writeKey("routing");
        this.routing.serialize(generator, mapper);
        generator.writeKey("num_search_segments");
        generator.write(this.numSearchSegments);
        generator.writeKey("segments");
        generator.writeStartObject();
        for (Map.Entry<String, Segment> item0 : this.segments.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupShardsSegmentDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::numCommittedSegments, JsonpDeserializer.integerDeserializer(), "num_committed_segments", new String[0]);
        op.add(Builder::routing, ShardSegmentRouting._DESERIALIZER, "routing", new String[0]);
        op.add(Builder::numSearchSegments, JsonpDeserializer.integerDeserializer(), "num_search_segments", new String[0]);
        op.add(Builder::segments, JsonpDeserializer.stringMapDeserializer(Segment._DESERIALIZER), "segments", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardsSegment> {
        private Integer numCommittedSegments;
        private ShardSegmentRouting routing;
        private Integer numSearchSegments;
        private Map<String, Segment> segments;

        public Builder numCommittedSegments(int value) {
            this.numCommittedSegments = value;
            return this;
        }

        public Builder routing(ShardSegmentRouting value) {
            this.routing = value;
            return this;
        }

        public Builder routing(Function<ShardSegmentRouting.Builder, ObjectBuilder<ShardSegmentRouting>> fn) {
            return this.routing(fn.apply(new ShardSegmentRouting.Builder()).build());
        }

        public Builder numSearchSegments(int value) {
            this.numSearchSegments = value;
            return this;
        }

        public Builder segments(Map<String, Segment> value) {
            this.segments = value;
            return this;
        }

        public Builder putSegments(String key, Segment value) {
            if (this.segments == null) {
                this.segments = new HashMap<String, Segment>();
            }
            this.segments.put(key, value);
            return this;
        }

        public Builder segments(String key, Function<Segment.Builder, ObjectBuilder<Segment>> fn) {
            return this.segments(Collections.singletonMap(key, fn.apply(new Segment.Builder()).build()));
        }

        public Builder putSegments(String key, Function<Segment.Builder, ObjectBuilder<Segment>> fn) {
            return this.putSegments(key, fn.apply(new Segment.Builder()).build());
        }

        @Override
        public ShardsSegment build() {
            return new ShardsSegment(this);
        }
    }
}

