/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.elasticsearch.indices.recovery.RecoveryBytes;
import co.elastic.clients.elasticsearch.indices.recovery.RecoveryFiles;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RecoveryIndexStatus
implements JsonpSerializable {
    @Nullable
    private final RecoveryBytes bytes;
    private final RecoveryFiles files;
    private final RecoveryBytes size;
    @Nullable
    private final String sourceThrottleTime;
    private final String sourceThrottleTimeInMillis;
    @Nullable
    private final String targetThrottleTime;
    private final String targetThrottleTimeInMillis;
    private final String totalTimeInMillis;
    @Nullable
    private final String totalTime;
    public static final JsonpDeserializer<RecoveryIndexStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryIndexStatus::setupRecoveryIndexStatusDeserializer, Builder::build);

    public RecoveryIndexStatus(Builder builder) {
        this.bytes = builder.bytes;
        this.files = Objects.requireNonNull(builder.files, "files");
        this.size = Objects.requireNonNull(builder.size, "size");
        this.sourceThrottleTime = builder.sourceThrottleTime;
        this.sourceThrottleTimeInMillis = Objects.requireNonNull(builder.sourceThrottleTimeInMillis, "source_throttle_time_in_millis");
        this.targetThrottleTime = builder.targetThrottleTime;
        this.targetThrottleTimeInMillis = Objects.requireNonNull(builder.targetThrottleTimeInMillis, "target_throttle_time_in_millis");
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
        this.totalTime = builder.totalTime;
    }

    public RecoveryIndexStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public RecoveryBytes bytes() {
        return this.bytes;
    }

    public RecoveryFiles files() {
        return this.files;
    }

    public RecoveryBytes size() {
        return this.size;
    }

    @Nullable
    public String sourceThrottleTime() {
        return this.sourceThrottleTime;
    }

    public String sourceThrottleTimeInMillis() {
        return this.sourceThrottleTimeInMillis;
    }

    @Nullable
    public String targetThrottleTime() {
        return this.targetThrottleTime;
    }

    public String targetThrottleTimeInMillis() {
        return this.targetThrottleTimeInMillis;
    }

    public String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Nullable
    public String totalTime() {
        return this.totalTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.bytes != null) {
            generator.writeKey("bytes");
            this.bytes.serialize(generator, mapper);
        }
        generator.writeKey("files");
        this.files.serialize(generator, mapper);
        generator.writeKey("size");
        this.size.serialize(generator, mapper);
        if (this.sourceThrottleTime != null) {
            generator.writeKey("source_throttle_time");
            generator.write(this.sourceThrottleTime);
        }
        generator.writeKey("source_throttle_time_in_millis");
        generator.write(this.sourceThrottleTimeInMillis);
        if (this.targetThrottleTime != null) {
            generator.writeKey("target_throttle_time");
            generator.write(this.targetThrottleTime);
        }
        generator.writeKey("target_throttle_time_in_millis");
        generator.write(this.targetThrottleTimeInMillis);
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
    }

    protected static void setupRecoveryIndexStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bytes, RecoveryBytes._DESERIALIZER, "bytes", new String[0]);
        op.add(Builder::files, RecoveryFiles._DESERIALIZER, "files", new String[0]);
        op.add(Builder::size, RecoveryBytes._DESERIALIZER, "size", new String[0]);
        op.add(Builder::sourceThrottleTime, JsonpDeserializer.stringDeserializer(), "source_throttle_time", new String[0]);
        op.add(Builder::sourceThrottleTimeInMillis, JsonpDeserializer.stringDeserializer(), "source_throttle_time_in_millis", new String[0]);
        op.add(Builder::targetThrottleTime, JsonpDeserializer.stringDeserializer(), "target_throttle_time", new String[0]);
        op.add(Builder::targetThrottleTimeInMillis, JsonpDeserializer.stringDeserializer(), "target_throttle_time_in_millis", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis", new String[0]);
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RecoveryIndexStatus> {
        @Nullable
        private RecoveryBytes bytes;
        private RecoveryFiles files;
        private RecoveryBytes size;
        @Nullable
        private String sourceThrottleTime;
        private String sourceThrottleTimeInMillis;
        @Nullable
        private String targetThrottleTime;
        private String targetThrottleTimeInMillis;
        private String totalTimeInMillis;
        @Nullable
        private String totalTime;

        public Builder bytes(@Nullable RecoveryBytes value) {
            this.bytes = value;
            return this;
        }

        public Builder bytes(Function<RecoveryBytes.Builder, ObjectBuilder<RecoveryBytes>> fn) {
            return this.bytes(fn.apply(new RecoveryBytes.Builder()).build());
        }

        public Builder files(RecoveryFiles value) {
            this.files = value;
            return this;
        }

        public Builder files(Function<RecoveryFiles.Builder, ObjectBuilder<RecoveryFiles>> fn) {
            return this.files(fn.apply(new RecoveryFiles.Builder()).build());
        }

        public Builder size(RecoveryBytes value) {
            this.size = value;
            return this;
        }

        public Builder size(Function<RecoveryBytes.Builder, ObjectBuilder<RecoveryBytes>> fn) {
            return this.size(fn.apply(new RecoveryBytes.Builder()).build());
        }

        public Builder sourceThrottleTime(@Nullable String value) {
            this.sourceThrottleTime = value;
            return this;
        }

        public Builder sourceThrottleTimeInMillis(String value) {
            this.sourceThrottleTimeInMillis = value;
            return this;
        }

        public Builder targetThrottleTime(@Nullable String value) {
            this.targetThrottleTime = value;
            return this;
        }

        public Builder targetThrottleTimeInMillis(String value) {
            this.targetThrottleTimeInMillis = value;
            return this;
        }

        public Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        public Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        @Override
        public RecoveryIndexStatus build() {
            return new RecoveryIndexStatus(this);
        }
    }
}

