/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.elasticsearch.indices.recovery.FileDetails;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RecoveryFiles
implements JsonpSerializable {
    @Nullable
    private final List<FileDetails> details;
    private final String percent;
    private final long recovered;
    private final long reused;
    private final long total;
    public static final JsonpDeserializer<RecoveryFiles> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryFiles::setupRecoveryFilesDeserializer, Builder::build);

    public RecoveryFiles(Builder builder) {
        this.details = ModelTypeHelper.unmodifiable(builder.details);
        this.percent = Objects.requireNonNull(builder.percent, "percent");
        this.recovered = Objects.requireNonNull(builder.recovered, "recovered");
        this.reused = Objects.requireNonNull(builder.reused, "reused");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public RecoveryFiles(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<FileDetails> details() {
        return this.details;
    }

    public String percent() {
        return this.percent;
    }

    public long recovered() {
        return this.recovered;
    }

    public long reused() {
        return this.reused;
    }

    public long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.details != null) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (FileDetails item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("percent");
        generator.write(this.percent);
        generator.writeKey("recovered");
        generator.write(this.recovered);
        generator.writeKey("reused");
        generator.write(this.reused);
        generator.writeKey("total");
        generator.write(this.total);
    }

    protected static void setupRecoveryFilesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(FileDetails._DESERIALIZER), "details", new String[0]);
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent", new String[0]);
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered", new String[0]);
        op.add(Builder::reused, JsonpDeserializer.longDeserializer(), "reused", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RecoveryFiles> {
        @Nullable
        private List<FileDetails> details;
        private String percent;
        private Long recovered;
        private Long reused;
        private Long total;

        public Builder details(@Nullable List<FileDetails> value) {
            this.details = value;
            return this;
        }

        public Builder details(FileDetails ... value) {
            this.details = Arrays.asList(value);
            return this;
        }

        public Builder addDetails(FileDetails value) {
            if (this.details == null) {
                this.details = new ArrayList<FileDetails>();
            }
            this.details.add(value);
            return this;
        }

        public Builder details(Function<FileDetails.Builder, ObjectBuilder<FileDetails>> fn) {
            return this.details(fn.apply(new FileDetails.Builder()).build());
        }

        public Builder addDetails(Function<FileDetails.Builder, ObjectBuilder<FileDetails>> fn) {
            return this.addDetails(fn.apply(new FileDetails.Builder()).build());
        }

        public Builder percent(String value) {
            this.percent = value;
            return this;
        }

        public Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        public Builder reused(long value) {
            this.reused = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        public RecoveryFiles build() {
            return new RecoveryFiles(this);
        }
    }
}

