/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SplitResponse
extends AcknowledgedResponseBase {
    private final boolean shardsAcknowledged;
    private final String index;
    public static final JsonpDeserializer<SplitResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SplitResponse::setupSplitResponseDeserializer, Builder::build);

    public SplitResponse(Builder builder) {
        super(builder);
        this.shardsAcknowledged = Objects.requireNonNull(builder.shardsAcknowledged, "shards_acknowledged");
        this.index = Objects.requireNonNull(builder.index, "index");
    }

    public SplitResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    public String index() {
        return this.index;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
        generator.writeKey("index");
        generator.write(this.index);
    }

    protected static void setupSplitResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SplitResponse> {
        private Boolean shardsAcknowledged;
        private String index;

        public Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SplitResponse build() {
            return new SplitResponse(this);
        }
    }
}

