/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.PutTemplateResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutTemplateRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final Boolean create;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean includeTypeName;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final Map<String, Alias> aliases;
    @Nullable
    private final List<String> indexPatterns;
    @Nullable
    private final TypeMapping mappings;
    @Nullable
    private final Integer order;
    @Nullable
    private final Map<String, JsonData> settings;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PutTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTemplateRequest::setupPutTemplateRequestDeserializer, Builder::build);
    public static final Endpoint<PutTemplateRequest, PutTemplateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutTemplateRequest, PutTemplateResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.create != null) {
            params.put("create", String.valueOf(request.create));
        }
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutTemplateResponse._DESERIALIZER);

    public PutTemplateRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.create = builder.create;
        this.flatSettings = builder.flatSettings;
        this.includeTypeName = builder.includeTypeName;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.aliases = ModelTypeHelper.unmodifiable(builder.aliases);
        this.indexPatterns = ModelTypeHelper.unmodifiable(builder.indexPatterns);
        this.mappings = builder.mappings;
        this.order = builder.order;
        this.settings = ModelTypeHelper.unmodifiable(builder.settings);
        this.version = builder.version;
    }

    public PutTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Boolean create() {
        return this.create;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean includeTypeName() {
        return this.includeTypeName;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nullable
    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public Integer order() {
        return this.order;
    }

    @Nullable
    public Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aliases != null) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry entry : this.aliases.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Alias)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.indexPatterns != null) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.order != null) {
            generator.writeKey("order");
            generator.write(this.order.intValue());
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.settings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupPutTemplateRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases", new String[0]);
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::order, JsonpDeserializer.integerDeserializer(), "order", new String[0]);
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutTemplateRequest> {
        private String name;
        @Nullable
        private Boolean create;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean includeTypeName;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private Map<String, Alias> aliases;
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private Integer order;
        @Nullable
        private Map<String, JsonData> settings;
        @Nullable
        private Long version;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder aliases(@Nullable Map<String, Alias> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, Alias value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, Alias>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new Alias.Builder()).build()));
        }

        public Builder putAliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.putAliases(key, fn.apply(new Alias.Builder()).build());
        }

        public Builder indexPatterns(@Nullable List<String> value) {
            this.indexPatterns = value;
            return this;
        }

        public Builder indexPatterns(String ... value) {
            this.indexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addIndexPatterns(String value) {
            if (this.indexPatterns == null) {
                this.indexPatterns = new ArrayList<String>();
            }
            this.indexPatterns.add(value);
            return this;
        }

        public Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder order(@Nullable Integer value) {
            this.order = value;
            return this;
        }

        public Builder settings(@Nullable Map<String, JsonData> value) {
            this.settings = value;
            return this;
        }

        public Builder putSettings(String key, JsonData value) {
            if (this.settings == null) {
                this.settings = new HashMap<String, JsonData>();
            }
            this.settings.put(key, value);
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        public PutTemplateRequest build() {
            return new PutTemplateRequest(this);
        }
    }
}

