/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.EmptyObject;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.PutIndexTemplateResponse;
import co.elastic.clients.elasticsearch.indices.put_index_template.IndexTemplateMapping;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutIndexTemplateRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final List<String> indexPatterns;
    @Nullable
    private final List<String> composedOf;
    @Nullable
    private final IndexTemplateMapping template;
    @Nullable
    private final EmptyObject dataStream;
    @Nullable
    private final Integer priority;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<PutIndexTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutIndexTemplateRequest::setupPutIndexTemplateRequestDeserializer, Builder::build);
    public static final Endpoint<PutIndexTemplateRequest, PutIndexTemplateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutIndexTemplateRequest, PutIndexTemplateResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutIndexTemplateResponse._DESERIALIZER);

    public PutIndexTemplateRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.indexPatterns = ModelTypeHelper.unmodifiable(builder.indexPatterns);
        this.composedOf = ModelTypeHelper.unmodifiable(builder.composedOf);
        this.template = builder.template;
        this.dataStream = builder.dataStream;
        this.priority = builder.priority;
        this.version = builder.version;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
    }

    public PutIndexTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public IndexTemplateMapping template() {
        return this.template;
    }

    @Nullable
    public EmptyObject dataStream() {
        return this.dataStream;
    }

    @Nullable
    public Integer priority() {
        return this.priority;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexPatterns != null) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.composedOf != null) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            this.dataStream.serialize(generator, mapper);
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.intValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutIndexTemplateRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns", new String[0]);
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of", new String[0]);
        op.add(Builder::template, IndexTemplateMapping._DESERIALIZER, "template", new String[0]);
        op.add(Builder::dataStream, EmptyObject._DESERIALIZER, "data_stream", new String[0]);
        op.add(Builder::priority, JsonpDeserializer.integerDeserializer(), "priority", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutIndexTemplateRequest> {
        private String name;
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private List<String> composedOf;
        @Nullable
        private IndexTemplateMapping template;
        @Nullable
        private EmptyObject dataStream;
        @Nullable
        private Integer priority;
        @Nullable
        private Long version;
        @Nullable
        private Map<String, JsonData> meta;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder indexPatterns(@Nullable List<String> value) {
            this.indexPatterns = value;
            return this;
        }

        public Builder indexPatterns(String ... value) {
            this.indexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addIndexPatterns(String value) {
            if (this.indexPatterns == null) {
                this.indexPatterns = new ArrayList<String>();
            }
            this.indexPatterns.add(value);
            return this;
        }

        public Builder composedOf(@Nullable List<String> value) {
            this.composedOf = value;
            return this;
        }

        public Builder composedOf(String ... value) {
            this.composedOf = Arrays.asList(value);
            return this;
        }

        public Builder addComposedOf(String value) {
            if (this.composedOf == null) {
                this.composedOf = new ArrayList<String>();
            }
            this.composedOf.add(value);
            return this;
        }

        public Builder template(@Nullable IndexTemplateMapping value) {
            this.template = value;
            return this;
        }

        public Builder template(Function<IndexTemplateMapping.Builder, ObjectBuilder<IndexTemplateMapping>> fn) {
            return this.template(fn.apply(new IndexTemplateMapping.Builder()).build());
        }

        public Builder dataStream(@Nullable EmptyObject value) {
            this.dataStream = value;
            return this;
        }

        public Builder dataStream(Function<EmptyObject.Builder, ObjectBuilder<EmptyObject>> fn) {
            return this.dataStream(fn.apply(new EmptyObject.Builder()).build());
        }

        public Builder priority(@Nullable Integer value) {
            this.priority = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        @Override
        public PutIndexTemplateRequest build() {
            return new PutIndexTemplateRequest(this);
        }
    }
}

