/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.indices.PutAliasResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutAliasRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> index;
    private final String name;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final Query filter;
    @Nullable
    private final String indexRouting;
    @Nullable
    private final Boolean isWriteIndex;
    @Nullable
    private final String routing;
    @Nullable
    private final String searchRouting;
    public static final JsonpDeserializer<PutAliasRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAliasRequest::setupPutAliasRequestDeserializer, Builder::build);
    public static final Endpoint<PutAliasRequest, PutAliasResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutAliasRequest, PutAliasResponse>(request -> "PUT", request -> {
        boolean _index = true;
        int _name = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_alias");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAliasResponse._DESERIALIZER);

    public PutAliasRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.filter = builder.filter;
        this.indexRouting = builder.indexRouting;
        this.isWriteIndex = builder.isWriteIndex;
        this.routing = builder.routing;
        this.searchRouting = builder.searchRouting;
    }

    public PutAliasRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Query filter() {
        return this.filter;
    }

    @Nullable
    public String indexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String searchRouting() {
        return this.searchRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.indexRouting != null) {
            generator.writeKey("index_routing");
            generator.write(this.indexRouting);
        }
        if (this.isWriteIndex != null) {
            generator.writeKey("is_write_index");
            generator.write(this.isWriteIndex.booleanValue());
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.searchRouting != null) {
            generator.writeKey("search_routing");
            generator.write(this.searchRouting);
        }
    }

    protected static void setupPutAliasRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::filter, Query._DESERIALIZER, "filter", new String[0]);
        op.add(Builder::indexRouting, JsonpDeserializer.stringDeserializer(), "index_routing", new String[0]);
        op.add(Builder::isWriteIndex, JsonpDeserializer.booleanDeserializer(), "is_write_index", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::searchRouting, JsonpDeserializer.stringDeserializer(), "search_routing", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutAliasRequest> {
        private List<String> index;
        private String name;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private Query filter;
        @Nullable
        private String indexRouting;
        @Nullable
        private Boolean isWriteIndex;
        @Nullable
        private String routing;
        @Nullable
        private String searchRouting;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public Builder indexRouting(@Nullable String value) {
            this.indexRouting = value;
            return this;
        }

        public Builder isWriteIndex(@Nullable Boolean value) {
            this.isWriteIndex = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder searchRouting(@Nullable String value) {
            this.searchRouting = value;
            return this;
        }

        @Override
        public PutAliasRequest build() {
            return new PutAliasRequest(this);
        }
    }
}

