/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.explain_lifecycle;

import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainManaged;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainUnmanaged;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class LifecycleExplain
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<LifecycleExplain> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, LifecycleExplain::setupLifecycleExplainDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public LifecycleExplain(LifecycleExplainVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends LifecycleExplainVariant> LifecycleExplain(ObjectBuilder<T> builder) {
        this((LifecycleExplainVariant)builder.build());
    }

    private LifecycleExplain(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public LifecycleExplain(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public LifecycleExplainManaged true_() {
        return (LifecycleExplainManaged)TaggedUnionUtils.get(this, TRUE);
    }

    public LifecycleExplainUnmanaged false_() {
        return (LifecycleExplainUnmanaged)TaggedUnionUtils.get(this, FALSE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupLifecycleExplainDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::true_, LifecycleExplainManaged._DESERIALIZER, TRUE, new String[0]);
        op.add(Builder::false_, LifecycleExplainUnmanaged._DESERIALIZER, FALSE, new String[0]);
        op.setTypeProperty("managed");
    }

    public static class Builder
    implements ObjectBuilder<LifecycleExplain> {
        private String _type;
        private JsonpSerializable _value;

        public Builder true_(LifecycleExplainManaged v) {
            this._type = LifecycleExplain.TRUE;
            this._value = v;
            return this;
        }

        public Builder true_(Function<LifecycleExplainManaged.Builder, ObjectBuilder<LifecycleExplainManaged>> f) {
            return this.true_(f.apply(new LifecycleExplainManaged.Builder()).build());
        }

        public Builder false_(LifecycleExplainUnmanaged v) {
            this._type = LifecycleExplain.FALSE;
            this._value = v;
            return this;
        }

        public Builder false_(Function<LifecycleExplainUnmanaged.Builder, ObjectBuilder<LifecycleExplainUnmanaged>> f) {
            return this.false_(f.apply(new LifecycleExplainUnmanaged.Builder()).build());
        }

        @Override
        public LifecycleExplain build() {
            return new LifecycleExplain(this);
        }
    }
}

