/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.elasticsearch.graph.Connection;
import co.elastic.clients.elasticsearch.graph.Vertex;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExploreResponse
implements JsonpSerializable {
    private final List<Connection> connections;
    private final List<ShardFailure> failures;
    private final boolean timedOut;
    private final long took;
    private final List<Vertex> vertices;
    public static final JsonpDeserializer<ExploreResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExploreResponse::setupExploreResponseDeserializer, Builder::build);

    public ExploreResponse(Builder builder) {
        this.connections = ModelTypeHelper.unmodifiableNonNull(builder.connections, "connections");
        this.failures = ModelTypeHelper.unmodifiableNonNull(builder.failures, "failures");
        this.timedOut = Objects.requireNonNull(builder.timedOut, "timed_out");
        this.took = Objects.requireNonNull(builder.took, "took");
        this.vertices = ModelTypeHelper.unmodifiableNonNull(builder.vertices, "vertices");
    }

    public ExploreResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Connection> connections() {
        return this.connections;
    }

    public List<ShardFailure> failures() {
        return this.failures;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public long took() {
        return this.took;
    }

    public List<Vertex> vertices() {
        return this.vertices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("connections");
        generator.writeStartArray();
        for (Connection connection : this.connections) {
            connection.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("failures");
        generator.writeStartArray();
        for (ShardFailure shardFailure : this.failures) {
            shardFailure.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("vertices");
        generator.writeStartArray();
        for (Vertex vertex : this.vertices) {
            vertex.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupExploreResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::connections, JsonpDeserializer.arrayDeserializer(Connection._DESERIALIZER), "connections", new String[0]);
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures", new String[0]);
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(Builder::vertices, JsonpDeserializer.arrayDeserializer(Vertex._DESERIALIZER), "vertices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExploreResponse> {
        private List<Connection> connections;
        private List<ShardFailure> failures;
        private Boolean timedOut;
        private Long took;
        private List<Vertex> vertices;

        public Builder connections(List<Connection> value) {
            this.connections = value;
            return this;
        }

        public Builder connections(Connection ... value) {
            this.connections = Arrays.asList(value);
            return this;
        }

        public Builder addConnections(Connection value) {
            if (this.connections == null) {
                this.connections = new ArrayList<Connection>();
            }
            this.connections.add(value);
            return this;
        }

        public Builder connections(Function<Connection.Builder, ObjectBuilder<Connection>> fn) {
            return this.connections(fn.apply(new Connection.Builder()).build());
        }

        public Builder addConnections(Function<Connection.Builder, ObjectBuilder<Connection>> fn) {
            return this.addConnections(fn.apply(new Connection.Builder()).build());
        }

        public Builder failures(List<ShardFailure> value) {
            this.failures = value;
            return this;
        }

        public Builder failures(ShardFailure ... value) {
            this.failures = Arrays.asList(value);
            return this;
        }

        public Builder addFailures(ShardFailure value) {
            if (this.failures == null) {
                this.failures = new ArrayList<ShardFailure>();
            }
            this.failures.add(value);
            return this;
        }

        public Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build());
        }

        public Builder addFailures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.addFailures(fn.apply(new ShardFailure.Builder()).build());
        }

        public Builder timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public Builder took(long value) {
            this.took = value;
            return this;
        }

        public Builder vertices(List<Vertex> value) {
            this.vertices = value;
            return this;
        }

        public Builder vertices(Vertex ... value) {
            this.vertices = Arrays.asList(value);
            return this;
        }

        public Builder addVertices(Vertex value) {
            if (this.vertices == null) {
                this.vertices = new ArrayList<Vertex>();
            }
            this.vertices.add(value);
            return this;
        }

        public Builder vertices(Function<Vertex.Builder, ObjectBuilder<Vertex>> fn) {
            return this.vertices(fn.apply(new Vertex.Builder()).build());
        }

        public Builder addVertices(Function<Vertex.Builder, ObjectBuilder<Vertex>> fn) {
            return this.addVertices(fn.apply(new Vertex.Builder()).build());
        }

        @Override
        public ExploreResponse build() {
            return new ExploreResponse(this);
        }
    }
}

