/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CoordinatorStats
implements JsonpSerializable {
    private final long executedSearchesTotal;
    private final String nodeId;
    private final int queueSize;
    private final int remoteRequestsCurrent;
    private final long remoteRequestsTotal;
    public static final JsonpDeserializer<CoordinatorStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CoordinatorStats::setupCoordinatorStatsDeserializer, Builder::build);

    public CoordinatorStats(Builder builder) {
        this.executedSearchesTotal = Objects.requireNonNull(builder.executedSearchesTotal, "executed_searches_total");
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
        this.queueSize = Objects.requireNonNull(builder.queueSize, "queue_size");
        this.remoteRequestsCurrent = Objects.requireNonNull(builder.remoteRequestsCurrent, "remote_requests_current");
        this.remoteRequestsTotal = Objects.requireNonNull(builder.remoteRequestsTotal, "remote_requests_total");
    }

    public CoordinatorStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long executedSearchesTotal() {
        return this.executedSearchesTotal;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public int queueSize() {
        return this.queueSize;
    }

    public int remoteRequestsCurrent() {
        return this.remoteRequestsCurrent;
    }

    public long remoteRequestsTotal() {
        return this.remoteRequestsTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("executed_searches_total");
        generator.write(this.executedSearchesTotal);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("queue_size");
        generator.write(this.queueSize);
        generator.writeKey("remote_requests_current");
        generator.write(this.remoteRequestsCurrent);
        generator.writeKey("remote_requests_total");
        generator.write(this.remoteRequestsTotal);
    }

    protected static void setupCoordinatorStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::executedSearchesTotal, JsonpDeserializer.longDeserializer(), "executed_searches_total", new String[0]);
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
        op.add(Builder::queueSize, JsonpDeserializer.integerDeserializer(), "queue_size", new String[0]);
        op.add(Builder::remoteRequestsCurrent, JsonpDeserializer.integerDeserializer(), "remote_requests_current", new String[0]);
        op.add(Builder::remoteRequestsTotal, JsonpDeserializer.longDeserializer(), "remote_requests_total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CoordinatorStats> {
        private Long executedSearchesTotal;
        private String nodeId;
        private Integer queueSize;
        private Integer remoteRequestsCurrent;
        private Long remoteRequestsTotal;

        public Builder executedSearchesTotal(long value) {
            this.executedSearchesTotal = value;
            return this;
        }

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public Builder queueSize(int value) {
            this.queueSize = value;
            return this;
        }

        public Builder remoteRequestsCurrent(int value) {
            this.remoteRequestsCurrent = value;
            return this;
        }

        public Builder remoteRequestsTotal(long value) {
            this.remoteRequestsTotal = value;
            return this;
        }

        @Override
        public CoordinatorStats build() {
            return new CoordinatorStats(this);
        }
    }
}

