/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.dangling_indices.list_dangling_indices;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DanglingIndex
implements JsonpSerializable {
    private final String indexName;
    private final String indexUuid;
    private final String creationDateMillis;
    private final List<String> nodeIds;
    public static final JsonpDeserializer<DanglingIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DanglingIndex::setupDanglingIndexDeserializer, Builder::build);

    public DanglingIndex(Builder builder) {
        this.indexName = Objects.requireNonNull(builder.indexName, "index_name");
        this.indexUuid = Objects.requireNonNull(builder.indexUuid, "index_uuid");
        this.creationDateMillis = Objects.requireNonNull(builder.creationDateMillis, "creation_date_millis");
        this.nodeIds = ModelTypeHelper.unmodifiableNonNull(builder.nodeIds, "node_ids");
    }

    public DanglingIndex(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String indexName() {
        return this.indexName;
    }

    public String indexUuid() {
        return this.indexUuid;
    }

    public String creationDateMillis() {
        return this.creationDateMillis;
    }

    public List<String> nodeIds() {
        return this.nodeIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_name");
        generator.write(this.indexName);
        generator.writeKey("index_uuid");
        generator.write(this.indexUuid);
        generator.writeKey("creation_date_millis");
        generator.write(this.creationDateMillis);
        generator.writeKey("node_ids");
        generator.writeStartArray();
        for (String item0 : this.nodeIds) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupDanglingIndexDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name", new String[0]);
        op.add(Builder::indexUuid, JsonpDeserializer.stringDeserializer(), "index_uuid", new String[0]);
        op.add(Builder::creationDateMillis, JsonpDeserializer.stringDeserializer(), "creation_date_millis", new String[0]);
        op.add(Builder::nodeIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "node_ids", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DanglingIndex> {
        private String indexName;
        private String indexUuid;
        private String creationDateMillis;
        private List<String> nodeIds;

        public Builder indexName(String value) {
            this.indexName = value;
            return this;
        }

        public Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        public Builder creationDateMillis(String value) {
            this.creationDateMillis = value;
            return this;
        }

        public Builder nodeIds(List<String> value) {
            this.nodeIds = value;
            return this;
        }

        public Builder nodeIds(String ... value) {
            this.nodeIds = Arrays.asList(value);
            return this;
        }

        public Builder addNodeIds(String value) {
            if (this.nodeIds == null) {
                this.nodeIds = new ArrayList<String>();
            }
            this.nodeIds.add(value);
            return this;
        }

        @Override
        public DanglingIndex build() {
            return new DanglingIndex(this);
        }
    }
}

