/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.remote_info;

import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfoVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterRemoteSniffInfo
implements ClusterRemoteInfoVariant,
JsonpSerializable {
    private final boolean connected;
    private final int maxConnectionsPerCluster;
    private final long numNodesConnected;
    private final String initialConnectTimeout;
    private final boolean skipUnavailable;
    private final List<String> seeds;
    public static final JsonpDeserializer<ClusterRemoteSniffInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterRemoteSniffInfo::setupClusterRemoteSniffInfoDeserializer, Builder::build);

    public ClusterRemoteSniffInfo(Builder builder) {
        this.connected = Objects.requireNonNull(builder.connected, "connected");
        this.maxConnectionsPerCluster = Objects.requireNonNull(builder.maxConnectionsPerCluster, "max_connections_per_cluster");
        this.numNodesConnected = Objects.requireNonNull(builder.numNodesConnected, "num_nodes_connected");
        this.initialConnectTimeout = Objects.requireNonNull(builder.initialConnectTimeout, "initial_connect_timeout");
        this.skipUnavailable = Objects.requireNonNull(builder.skipUnavailable, "skip_unavailable");
        this.seeds = ModelTypeHelper.unmodifiableNonNull(builder.seeds, "seeds");
    }

    public ClusterRemoteSniffInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "sniff";
    }

    public boolean connected() {
        return this.connected;
    }

    public int maxConnectionsPerCluster() {
        return this.maxConnectionsPerCluster;
    }

    public long numNodesConnected() {
        return this.numNodesConnected;
    }

    public String initialConnectTimeout() {
        return this.initialConnectTimeout;
    }

    public boolean skipUnavailable() {
        return this.skipUnavailable;
    }

    public List<String> seeds() {
        return this.seeds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("mode", "sniff");
        generator.writeKey("connected");
        generator.write(this.connected);
        generator.writeKey("max_connections_per_cluster");
        generator.write(this.maxConnectionsPerCluster);
        generator.writeKey("num_nodes_connected");
        generator.write(this.numNodesConnected);
        generator.writeKey("initial_connect_timeout");
        generator.write(this.initialConnectTimeout);
        generator.writeKey("skip_unavailable");
        generator.write(this.skipUnavailable);
        generator.writeKey("seeds");
        generator.writeStartArray();
        for (String item0 : this.seeds) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupClusterRemoteSniffInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::connected, JsonpDeserializer.booleanDeserializer(), "connected", new String[0]);
        op.add(Builder::maxConnectionsPerCluster, JsonpDeserializer.integerDeserializer(), "max_connections_per_cluster", new String[0]);
        op.add(Builder::numNodesConnected, JsonpDeserializer.longDeserializer(), "num_nodes_connected", new String[0]);
        op.add(Builder::initialConnectTimeout, JsonpDeserializer.stringDeserializer(), "initial_connect_timeout", new String[0]);
        op.add(Builder::skipUnavailable, JsonpDeserializer.booleanDeserializer(), "skip_unavailable", new String[0]);
        op.add(Builder::seeds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "seeds", new String[0]);
        op.ignore("mode");
    }

    public static class Builder
    implements ObjectBuilder<ClusterRemoteSniffInfo> {
        private Boolean connected;
        private Integer maxConnectionsPerCluster;
        private Long numNodesConnected;
        private String initialConnectTimeout;
        private Boolean skipUnavailable;
        private List<String> seeds;

        public Builder connected(boolean value) {
            this.connected = value;
            return this;
        }

        public Builder maxConnectionsPerCluster(int value) {
            this.maxConnectionsPerCluster = value;
            return this;
        }

        public Builder numNodesConnected(long value) {
            this.numNodesConnected = value;
            return this;
        }

        public Builder initialConnectTimeout(String value) {
            this.initialConnectTimeout = value;
            return this;
        }

        public Builder skipUnavailable(boolean value) {
            this.skipUnavailable = value;
            return this;
        }

        public Builder seeds(List<String> value) {
            this.seeds = value;
            return this;
        }

        public Builder seeds(String ... value) {
            this.seeds = Arrays.asList(value);
            return this;
        }

        public Builder addSeeds(String value) {
            if (this.seeds == null) {
                this.seeds = new ArrayList<String>();
            }
            this.seeds.add(value);
            return this;
        }

        @Override
        public ClusterRemoteSniffInfo build() {
            return new ClusterRemoteSniffInfo(this);
        }
    }
}

