/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.health;

import co.elastic.clients.elasticsearch._types.Health;
import co.elastic.clients.elasticsearch.cluster.health.ShardHealthStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexHealthStats
implements JsonpSerializable {
    private final int activePrimaryShards;
    private final int activeShards;
    private final int initializingShards;
    private final int numberOfReplicas;
    private final int numberOfShards;
    private final int relocatingShards;
    @Nullable
    private final Map<String, ShardHealthStats> shards;
    private final Health status;
    private final int unassignedShards;
    public static final JsonpDeserializer<IndexHealthStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexHealthStats::setupIndexHealthStatsDeserializer, Builder::build);

    public IndexHealthStats(Builder builder) {
        this.activePrimaryShards = Objects.requireNonNull(builder.activePrimaryShards, "active_primary_shards");
        this.activeShards = Objects.requireNonNull(builder.activeShards, "active_shards");
        this.initializingShards = Objects.requireNonNull(builder.initializingShards, "initializing_shards");
        this.numberOfReplicas = Objects.requireNonNull(builder.numberOfReplicas, "number_of_replicas");
        this.numberOfShards = Objects.requireNonNull(builder.numberOfShards, "number_of_shards");
        this.relocatingShards = Objects.requireNonNull(builder.relocatingShards, "relocating_shards");
        this.shards = ModelTypeHelper.unmodifiable(builder.shards);
        this.status = Objects.requireNonNull(builder.status, "status");
        this.unassignedShards = Objects.requireNonNull(builder.unassignedShards, "unassigned_shards");
    }

    public IndexHealthStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int activePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int activeShards() {
        return this.activeShards;
    }

    public int initializingShards() {
        return this.initializingShards;
    }

    public int numberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public int relocatingShards() {
        return this.relocatingShards;
    }

    @Nullable
    public Map<String, ShardHealthStats> shards() {
        return this.shards;
    }

    public Health status() {
        return this.status;
    }

    public int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_primary_shards");
        generator.write(this.activePrimaryShards);
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("number_of_replicas");
        generator.write(this.numberOfReplicas);
        generator.writeKey("number_of_shards");
        generator.write(this.numberOfShards);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        if (this.shards != null) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, ShardHealthStats> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    protected static void setupIndexHealthStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::activePrimaryShards, JsonpDeserializer.integerDeserializer(), "active_primary_shards", new String[0]);
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards", new String[0]);
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards", new String[0]);
        op.add(Builder::numberOfReplicas, JsonpDeserializer.integerDeserializer(), "number_of_replicas", new String[0]);
        op.add(Builder::numberOfShards, JsonpDeserializer.integerDeserializer(), "number_of_shards", new String[0]);
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards", new String[0]);
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(ShardHealthStats._DESERIALIZER), "shards", new String[0]);
        op.add(Builder::status, Health._DESERIALIZER, "status", new String[0]);
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexHealthStats> {
        private Integer activePrimaryShards;
        private Integer activeShards;
        private Integer initializingShards;
        private Integer numberOfReplicas;
        private Integer numberOfShards;
        private Integer relocatingShards;
        @Nullable
        private Map<String, ShardHealthStats> shards;
        private Health status;
        private Integer unassignedShards;

        public Builder activePrimaryShards(int value) {
            this.activePrimaryShards = value;
            return this;
        }

        public Builder activeShards(int value) {
            this.activeShards = value;
            return this;
        }

        public Builder initializingShards(int value) {
            this.initializingShards = value;
            return this;
        }

        public Builder numberOfReplicas(int value) {
            this.numberOfReplicas = value;
            return this;
        }

        public Builder numberOfShards(int value) {
            this.numberOfShards = value;
            return this;
        }

        public Builder relocatingShards(int value) {
            this.relocatingShards = value;
            return this;
        }

        public Builder shards(@Nullable Map<String, ShardHealthStats> value) {
            this.shards = value;
            return this;
        }

        public Builder putShards(String key, ShardHealthStats value) {
            if (this.shards == null) {
                this.shards = new HashMap<String, ShardHealthStats>();
            }
            this.shards.put(key, value);
            return this;
        }

        public Builder shards(String key, Function<ShardHealthStats.Builder, ObjectBuilder<ShardHealthStats>> fn) {
            return this.shards(Collections.singletonMap(key, fn.apply(new ShardHealthStats.Builder()).build()));
        }

        public Builder putShards(String key, Function<ShardHealthStats.Builder, ObjectBuilder<ShardHealthStats>> fn) {
            return this.putShards(key, fn.apply(new ShardHealthStats.Builder()).build());
        }

        public Builder status(Health value) {
            this.status = value;
            return this;
        }

        public Builder unassignedShards(int value) {
            this.unassignedShards = value;
            return this;
        }

        @Override
        public IndexHealthStats build() {
            return new IndexHealthStats(this);
        }
    }
}

