/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.PutSettingsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutSettingsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final Map<String, JsonData> persistent;
    @Nullable
    private final Map<String, JsonData> transient_;
    public static final JsonpDeserializer<PutSettingsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutSettingsRequest::setupPutSettingsRequestDeserializer, Builder::build);
    public static final Endpoint<PutSettingsRequest, PutSettingsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutSettingsRequest, PutSettingsResponse>(request -> "PUT", request -> "/_cluster/settings", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutSettingsResponse._DESERIALIZER);

    public PutSettingsRequest(Builder builder) {
        this.flatSettings = builder.flatSettings;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.persistent = ModelTypeHelper.unmodifiable(builder.persistent);
        this.transient_ = ModelTypeHelper.unmodifiable(builder.transient_);
    }

    public PutSettingsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Map<String, JsonData> persistent() {
        return this.persistent;
    }

    @Nullable
    public Map<String, JsonData> transient_() {
        return this.transient_;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.persistent != null) {
            generator.writeKey("persistent");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.persistent.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.transient_ != null) {
            generator.writeKey("transient");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.transient_.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutSettingsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::persistent, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "persistent", new String[0]);
        op.add(Builder::transient_, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutSettingsRequest> {
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private Map<String, JsonData> persistent;
        @Nullable
        private Map<String, JsonData> transient_;

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder persistent(@Nullable Map<String, JsonData> value) {
            this.persistent = value;
            return this;
        }

        public Builder putPersistent(String key, JsonData value) {
            if (this.persistent == null) {
                this.persistent = new HashMap<String, JsonData>();
            }
            this.persistent.put(key, value);
            return this;
        }

        public Builder transient_(@Nullable Map<String, JsonData> value) {
            this.transient_ = value;
            return this;
        }

        public Builder putTransient(String key, JsonData value) {
            if (this.transient_ == null) {
                this.transient_ = new HashMap<String, JsonData>();
            }
            this.transient_.put(key, value);
            return this;
        }

        @Override
        public PutSettingsRequest build() {
            return new PutSettingsRequest(this);
        }
    }
}

