/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.pending_tasks.PendingTask;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class PendingTasksResponse
implements JsonpSerializable {
    private final List<PendingTask> tasks;
    public static final JsonpDeserializer<PendingTasksResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PendingTasksResponse::setupPendingTasksResponseDeserializer, Builder::build);

    public PendingTasksResponse(Builder builder) {
        this.tasks = ModelTypeHelper.unmodifiableNonNull(builder.tasks, "tasks");
    }

    public PendingTasksResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<PendingTask> tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("tasks");
        generator.writeStartArray();
        for (PendingTask item0 : this.tasks) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupPendingTasksResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::tasks, JsonpDeserializer.arrayDeserializer(PendingTask._DESERIALIZER), "tasks", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PendingTasksResponse> {
        private List<PendingTask> tasks;

        public Builder tasks(List<PendingTask> value) {
            this.tasks = value;
            return this;
        }

        public Builder tasks(PendingTask ... value) {
            this.tasks = Arrays.asList(value);
            return this;
        }

        public Builder addTasks(PendingTask value) {
            if (this.tasks == null) {
                this.tasks = new ArrayList<PendingTask>();
            }
            this.tasks.add(value);
            return this;
        }

        public Builder tasks(Function<PendingTask.Builder, ObjectBuilder<PendingTask>> fn) {
            return this.tasks(fn.apply(new PendingTask.Builder()).build());
        }

        public Builder addTasks(Function<PendingTask.Builder, ObjectBuilder<PendingTask>> fn) {
            return this.addTasks(fn.apply(new PendingTask.Builder()).build());
        }

        @Override
        public PendingTasksResponse build() {
            return new PendingTasksResponse(this);
        }
    }
}

