/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetSettingsResponse
implements JsonpSerializable {
    private final Map<String, JsonData> persistent;
    private final Map<String, JsonData> transient_;
    @Nullable
    private final Map<String, JsonData> defaults;
    public static final JsonpDeserializer<GetSettingsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetSettingsResponse::setupGetSettingsResponseDeserializer, Builder::build);

    public GetSettingsResponse(Builder builder) {
        this.persistent = ModelTypeHelper.unmodifiableNonNull(builder.persistent, "persistent");
        this.transient_ = ModelTypeHelper.unmodifiableNonNull(builder.transient_, "transient");
        this.defaults = ModelTypeHelper.unmodifiable(builder.defaults);
    }

    public GetSettingsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, JsonData> persistent() {
        return this.persistent;
    }

    public Map<String, JsonData> transient_() {
        return this.transient_;
    }

    @Nullable
    public Map<String, JsonData> defaults() {
        return this.defaults;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("persistent");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.persistent.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("transient");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.transient_.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.defaults != null) {
            generator.writeKey("defaults");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.defaults.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetSettingsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::persistent, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "persistent", new String[0]);
        op.add(Builder::transient_, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient", new String[0]);
        op.add(Builder::defaults, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "defaults", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetSettingsResponse> {
        private Map<String, JsonData> persistent;
        private Map<String, JsonData> transient_;
        @Nullable
        private Map<String, JsonData> defaults;

        public Builder persistent(Map<String, JsonData> value) {
            this.persistent = value;
            return this;
        }

        public Builder putPersistent(String key, JsonData value) {
            if (this.persistent == null) {
                this.persistent = new HashMap<String, JsonData>();
            }
            this.persistent.put(key, value);
            return this;
        }

        public Builder transient_(Map<String, JsonData> value) {
            this.transient_ = value;
            return this;
        }

        public Builder putTransient(String key, JsonData value) {
            if (this.transient_ == null) {
                this.transient_ = new HashMap<String, JsonData>();
            }
            this.transient_.put(key, value);
            return this;
        }

        public Builder defaults(@Nullable Map<String, JsonData> value) {
            this.defaults = value;
            return this;
        }

        public Builder putDefaults(String key, JsonData value) {
            if (this.defaults == null) {
                this.defaults = new HashMap<String, JsonData>();
            }
            this.defaults.put(key, value);
            return this;
        }

        @Override
        public GetSettingsResponse build() {
            return new GetSettingsResponse(this);
        }
    }
}

