/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.AliasDefinition;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ComponentTemplateSummary
implements JsonpSerializable {
    @Nullable
    private final Map<String, JsonData> meta;
    @Nullable
    private final Long version;
    private final Map<String, IndexSettings> settings;
    @Nullable
    private final TypeMapping mappings;
    @Nullable
    private final Map<String, AliasDefinition> aliases;
    public static final JsonpDeserializer<ComponentTemplateSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplateSummary::setupComponentTemplateSummaryDeserializer, Builder::build);

    public ComponentTemplateSummary(Builder builder) {
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
        this.version = builder.version;
        this.settings = ModelTypeHelper.unmodifiableNonNull(builder.settings, "settings");
        this.mappings = builder.mappings;
        this.aliases = ModelTypeHelper.unmodifiable(builder.aliases);
    }

    public ComponentTemplateSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    public Map<String, IndexSettings> settings() {
        return this.settings;
    }

    @Nullable
    public TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public Map<String, AliasDefinition> aliases() {
        return this.aliases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        generator.writeKey("settings");
        generator.writeStartObject();
        for (Map.Entry<String, JsonpSerializable> entry : this.settings.entrySet()) {
            generator.writeKey(entry.getKey());
            ((IndexSettings)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.aliases != null) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.aliases.entrySet()) {
                generator.writeKey(entry.getKey());
                ((AliasDefinition)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupComponentTemplateSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(IndexSettings._DESERIALIZER), "settings", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(AliasDefinition._DESERIALIZER), "aliases", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ComponentTemplateSummary> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Long version;
        private Map<String, IndexSettings> settings;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private Map<String, AliasDefinition> aliases;

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder settings(Map<String, IndexSettings> value) {
            this.settings = value;
            return this;
        }

        public Builder putSettings(String key, IndexSettings value) {
            if (this.settings == null) {
                this.settings = new HashMap<String, IndexSettings>();
            }
            this.settings.put(key, value);
            return this;
        }

        public Builder settings(String key, Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(Collections.singletonMap(key, fn.apply(new IndexSettings.Builder()).build()));
        }

        public Builder putSettings(String key, Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.putSettings(key, fn.apply(new IndexSettings.Builder()).build());
        }

        public Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder aliases(@Nullable Map<String, AliasDefinition> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, AliasDefinition value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, AliasDefinition>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new AliasDefinition.Builder()).build()));
        }

        public Builder putAliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.putAliases(key, fn.apply(new AliasDefinition.Builder()).build());
        }

        @Override
        public ComponentTemplateSummary build() {
            return new ComponentTemplateSummary(this);
        }
    }
}

