/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.AllocationExplainResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AllocationExplainRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean includeDiskInfo;
    @Nullable
    private final Boolean includeYesDecisions;
    @Nullable
    private final String currentNode;
    @Nullable
    private final String index;
    @Nullable
    private final Boolean primary;
    @Nullable
    private final Integer shard;
    public static final JsonpDeserializer<AllocationExplainRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationExplainRequest::setupAllocationExplainRequestDeserializer, Builder::build);
    public static final Endpoint<AllocationExplainRequest, AllocationExplainResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<AllocationExplainRequest, AllocationExplainResponse>(request -> "POST", request -> "/_cluster/allocation/explain", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.includeDiskInfo != null) {
            params.put("include_disk_info", String.valueOf(request.includeDiskInfo));
        }
        if (request.includeYesDecisions != null) {
            params.put("include_yes_decisions", String.valueOf(request.includeYesDecisions));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, AllocationExplainResponse._DESERIALIZER);

    public AllocationExplainRequest(Builder builder) {
        this.includeDiskInfo = builder.includeDiskInfo;
        this.includeYesDecisions = builder.includeYesDecisions;
        this.currentNode = builder.currentNode;
        this.index = builder.index;
        this.primary = builder.primary;
        this.shard = builder.shard;
    }

    public AllocationExplainRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean includeDiskInfo() {
        return this.includeDiskInfo;
    }

    @Nullable
    public Boolean includeYesDecisions() {
        return this.includeYesDecisions;
    }

    @Nullable
    public String currentNode() {
        return this.currentNode;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public Boolean primary() {
        return this.primary;
    }

    @Nullable
    public Integer shard() {
        return this.shard;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentNode != null) {
            generator.writeKey("current_node");
            generator.write(this.currentNode);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.primary != null) {
            generator.writeKey("primary");
            generator.write(this.primary.booleanValue());
        }
        if (this.shard != null) {
            generator.writeKey("shard");
            generator.write(this.shard.intValue());
        }
    }

    protected static void setupAllocationExplainRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::currentNode, JsonpDeserializer.stringDeserializer(), "current_node", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary", new String[0]);
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AllocationExplainRequest> {
        @Nullable
        private Boolean includeDiskInfo;
        @Nullable
        private Boolean includeYesDecisions;
        @Nullable
        private String currentNode;
        @Nullable
        private String index;
        @Nullable
        private Boolean primary;
        @Nullable
        private Integer shard;

        public Builder includeDiskInfo(@Nullable Boolean value) {
            this.includeDiskInfo = value;
            return this;
        }

        public Builder includeYesDecisions(@Nullable Boolean value) {
            this.includeYesDecisions = value;
            return this;
        }

        public Builder currentNode(@Nullable String value) {
            this.currentNode = value;
            return this;
        }

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder primary(@Nullable Boolean value) {
            this.primary = value;
            return this;
        }

        public Builder shard(@Nullable Integer value) {
            this.shard = value;
            return this;
        }

        @Override
        public AllocationExplainRequest build() {
            return new AllocationExplainRequest(this);
        }
    }
}

