/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ccr.FollowResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FollowRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final String leaderIndex;
    @Nullable
    private final Long maxOutstandingReadRequests;
    @Nullable
    private final Long maxOutstandingWriteRequests;
    @Nullable
    private final Long maxReadRequestOperationCount;
    @Nullable
    private final String maxReadRequestSize;
    @Nullable
    private final String maxRetryDelay;
    @Nullable
    private final Long maxWriteBufferCount;
    @Nullable
    private final String maxWriteBufferSize;
    @Nullable
    private final Long maxWriteRequestOperationCount;
    @Nullable
    private final String maxWriteRequestSize;
    @Nullable
    private final String readPollTimeout;
    @Nullable
    private final String remoteCluster;
    public static final JsonpDeserializer<FollowRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowRequest::setupFollowRequestDeserializer, Builder::build);
    public static final Endpoint<FollowRequest, FollowResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<FollowRequest, FollowResponse>(request -> "PUT", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ccr");
            buf.append("/follow");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FollowResponse._DESERIALIZER);

    public FollowRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.waitForActiveShards = builder.waitForActiveShards;
        this.leaderIndex = builder.leaderIndex;
        this.maxOutstandingReadRequests = builder.maxOutstandingReadRequests;
        this.maxOutstandingWriteRequests = builder.maxOutstandingWriteRequests;
        this.maxReadRequestOperationCount = builder.maxReadRequestOperationCount;
        this.maxReadRequestSize = builder.maxReadRequestSize;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxWriteBufferCount = builder.maxWriteBufferCount;
        this.maxWriteBufferSize = builder.maxWriteBufferSize;
        this.maxWriteRequestOperationCount = builder.maxWriteRequestOperationCount;
        this.maxWriteRequestSize = builder.maxWriteRequestSize;
        this.readPollTimeout = builder.readPollTimeout;
        this.remoteCluster = builder.remoteCluster;
    }

    public FollowRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public String leaderIndex() {
        return this.leaderIndex;
    }

    @Nullable
    public Long maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Nullable
    public Long maxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    @Nullable
    public Long maxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    @Nullable
    public String maxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    @Nullable
    public String maxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Nullable
    public Long maxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    @Nullable
    public String maxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    @Nullable
    public Long maxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    @Nullable
    public String maxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    @Nullable
    public String readPollTimeout() {
        return this.readPollTimeout;
    }

    @Nullable
    public String remoteCluster() {
        return this.remoteCluster;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.leaderIndex != null) {
            generator.writeKey("leader_index");
            generator.write(this.leaderIndex);
        }
        if (this.maxOutstandingReadRequests != null) {
            generator.writeKey("max_outstanding_read_requests");
            generator.write(this.maxOutstandingReadRequests.longValue());
        }
        if (this.maxOutstandingWriteRequests != null) {
            generator.writeKey("max_outstanding_write_requests");
            generator.write(this.maxOutstandingWriteRequests.longValue());
        }
        if (this.maxReadRequestOperationCount != null) {
            generator.writeKey("max_read_request_operation_count");
            generator.write(this.maxReadRequestOperationCount.longValue());
        }
        if (this.maxReadRequestSize != null) {
            generator.writeKey("max_read_request_size");
            generator.write(this.maxReadRequestSize);
        }
        if (this.maxRetryDelay != null) {
            generator.writeKey("max_retry_delay");
            generator.write(this.maxRetryDelay);
        }
        if (this.maxWriteBufferCount != null) {
            generator.writeKey("max_write_buffer_count");
            generator.write(this.maxWriteBufferCount.longValue());
        }
        if (this.maxWriteBufferSize != null) {
            generator.writeKey("max_write_buffer_size");
            generator.write(this.maxWriteBufferSize);
        }
        if (this.maxWriteRequestOperationCount != null) {
            generator.writeKey("max_write_request_operation_count");
            generator.write(this.maxWriteRequestOperationCount.longValue());
        }
        if (this.maxWriteRequestSize != null) {
            generator.writeKey("max_write_request_size");
            generator.write(this.maxWriteRequestSize);
        }
        if (this.readPollTimeout != null) {
            generator.writeKey("read_poll_timeout");
            generator.write(this.readPollTimeout);
        }
        if (this.remoteCluster != null) {
            generator.writeKey("remote_cluster");
            generator.write(this.remoteCluster);
        }
    }

    protected static void setupFollowRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::leaderIndex, JsonpDeserializer.stringDeserializer(), "leader_index", new String[0]);
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.longDeserializer(), "max_outstanding_read_requests", new String[0]);
        op.add(Builder::maxOutstandingWriteRequests, JsonpDeserializer.longDeserializer(), "max_outstanding_write_requests", new String[0]);
        op.add(Builder::maxReadRequestOperationCount, JsonpDeserializer.longDeserializer(), "max_read_request_operation_count", new String[0]);
        op.add(Builder::maxReadRequestSize, JsonpDeserializer.stringDeserializer(), "max_read_request_size", new String[0]);
        op.add(Builder::maxRetryDelay, JsonpDeserializer.stringDeserializer(), "max_retry_delay", new String[0]);
        op.add(Builder::maxWriteBufferCount, JsonpDeserializer.longDeserializer(), "max_write_buffer_count", new String[0]);
        op.add(Builder::maxWriteBufferSize, JsonpDeserializer.stringDeserializer(), "max_write_buffer_size", new String[0]);
        op.add(Builder::maxWriteRequestOperationCount, JsonpDeserializer.longDeserializer(), "max_write_request_operation_count", new String[0]);
        op.add(Builder::maxWriteRequestSize, JsonpDeserializer.stringDeserializer(), "max_write_request_size", new String[0]);
        op.add(Builder::readPollTimeout, JsonpDeserializer.stringDeserializer(), "read_poll_timeout", new String[0]);
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FollowRequest> {
        private String index;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private String leaderIndex;
        @Nullable
        private Long maxOutstandingReadRequests;
        @Nullable
        private Long maxOutstandingWriteRequests;
        @Nullable
        private Long maxReadRequestOperationCount;
        @Nullable
        private String maxReadRequestSize;
        @Nullable
        private String maxRetryDelay;
        @Nullable
        private Long maxWriteBufferCount;
        @Nullable
        private String maxWriteBufferSize;
        @Nullable
        private Long maxWriteRequestOperationCount;
        @Nullable
        private String maxWriteRequestSize;
        @Nullable
        private String readPollTimeout;
        @Nullable
        private String remoteCluster;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder leaderIndex(@Nullable String value) {
            this.leaderIndex = value;
            return this;
        }

        public Builder maxOutstandingReadRequests(@Nullable Long value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        public Builder maxOutstandingWriteRequests(@Nullable Long value) {
            this.maxOutstandingWriteRequests = value;
            return this;
        }

        public Builder maxReadRequestOperationCount(@Nullable Long value) {
            this.maxReadRequestOperationCount = value;
            return this;
        }

        public Builder maxReadRequestSize(@Nullable String value) {
            this.maxReadRequestSize = value;
            return this;
        }

        public Builder maxRetryDelay(@Nullable String value) {
            this.maxRetryDelay = value;
            return this;
        }

        public Builder maxWriteBufferCount(@Nullable Long value) {
            this.maxWriteBufferCount = value;
            return this;
        }

        public Builder maxWriteBufferSize(@Nullable String value) {
            this.maxWriteBufferSize = value;
            return this;
        }

        public Builder maxWriteRequestOperationCount(@Nullable Long value) {
            this.maxWriteRequestOperationCount = value;
            return this;
        }

        public Builder maxWriteRequestSize(@Nullable String value) {
            this.maxWriteRequestSize = value;
            return this;
        }

        public Builder readPollTimeout(@Nullable String value) {
            this.readPollTimeout = value;
            return this;
        }

        public Builder remoteCluster(@Nullable String value) {
            this.remoteCluster = value;
            return this;
        }

        @Override
        public FollowRequest build() {
            return new FollowRequest(this);
        }
    }
}

