/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.indices.IndicesRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class IndicesResponse
implements JsonpSerializable {
    private final List<IndicesRecord> valueBody;
    public static final JsonpDeserializer<IndicesResponse> _DESERIALIZER = IndicesResponse.createIndicesResponseDeserializer();

    public IndicesResponse(Builder builder) {
        this.valueBody = ModelTypeHelper.unmodifiableNonNull(builder.valueBody, "_value_body");
    }

    public IndicesResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<IndicesRecord> valueBody() {
        return this.valueBody;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (IndicesRecord item0 : this.valueBody) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<IndicesResponse> createIndicesResponseDeserializer() {
        JsonpDeserializer<List<IndicesRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(IndicesRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().valueBody((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<IndicesResponse> {
        private List<IndicesRecord> valueBody;

        public Builder valueBody(List<IndicesRecord> value) {
            this.valueBody = value;
            return this;
        }

        public Builder valueBody(IndicesRecord ... value) {
            this.valueBody = Arrays.asList(value);
            return this;
        }

        public Builder addValueBody(IndicesRecord value) {
            if (this.valueBody == null) {
                this.valueBody = new ArrayList<IndicesRecord>();
            }
            this.valueBody.add(value);
            return this;
        }

        public Builder valueBody(Function<IndicesRecord.Builder, ObjectBuilder<IndicesRecord>> fn) {
            return this.valueBody(fn.apply(new IndicesRecord.Builder()).build());
        }

        public Builder addValueBody(Function<IndicesRecord.Builder, ObjectBuilder<IndicesRecord>> fn) {
            return this.addValueBody(fn.apply(new IndicesRecord.Builder()).build());
        }

        @Override
        public IndicesResponse build() {
            return new IndicesResponse(this);
        }
    }
}

