/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.async_search.AsyncSearchResponseBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StatusResponse<TDocument>
extends AsyncSearchResponseBase {
    private final ShardStatistics shards;
    private final int completionStatus;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public StatusResponse(Builder<TDocument> builder) {
        super(builder);
        this.shards = Objects.requireNonNull(((Builder)builder).shards, "_shards");
        this.completionStatus = Objects.requireNonNull(((Builder)builder).completionStatus, "completion_status");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public StatusResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    public int completionStatus() {
        return this.completionStatus;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("completion_status");
        generator.write(this.completionStatus);
    }

    public static <TDocument> JsonpDeserializer<StatusResponse<TDocument>> createStatusResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> StatusResponse.setupStatusResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupStatusResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        AsyncSearchResponseBase.setupAsyncSearchResponseBaseDeserializer(op);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::completionStatus, JsonpDeserializer.integerDeserializer(), "completion_status", new String[0]);
    }

    public static class Builder<TDocument>
    extends AsyncSearchResponseBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<StatusResponse<TDocument>> {
        private ShardStatistics shards;
        private Integer completionStatus;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder<TDocument> completionStatus(int value) {
            this.completionStatus = value;
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public StatusResponse<TDocument> build() {
            return new StatusResponse(this);
        }
    }
}

