/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.elasticsearch._core.search.HitsMetadata;
import co.elastic.clients.elasticsearch._core.search.Profile;
import co.elastic.clients.elasticsearch._core.search.Suggestion;
import co.elastic.clients.elasticsearch._types.ClusterStatistics;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class AsyncSearch<TDocument>
implements JsonpSerializable {
    @Nullable
    private final Map<String, JsonValue> aggregations;
    @Nullable
    private final ClusterStatistics clusters;
    @Nullable
    private final Map<String, JsonData> fields;
    private final HitsMetadata<TDocument> hits;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final Long numReducePhases;
    @Nullable
    private final Profile profile;
    @Nullable
    private final String pitId;
    @Nullable
    private final String scrollId;
    private final ShardStatistics shards;
    @Nullable
    private final Map<String, List<Suggestion<TDocument>>> suggest;
    @Nullable
    private final Boolean terminatedEarly;
    private final boolean timedOut;
    private final long took;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public AsyncSearch(Builder<TDocument> builder) {
        this.aggregations = ModelTypeHelper.unmodifiable(((Builder)builder).aggregations);
        this.clusters = ((Builder)builder).clusters;
        this.fields = ModelTypeHelper.unmodifiable(((Builder)builder).fields);
        this.hits = Objects.requireNonNull(((Builder)builder).hits, "hits");
        this.maxScore = ((Builder)builder).maxScore;
        this.numReducePhases = ((Builder)builder).numReducePhases;
        this.profile = ((Builder)builder).profile;
        this.pitId = ((Builder)builder).pitId;
        this.scrollId = ((Builder)builder).scrollId;
        this.shards = Objects.requireNonNull(((Builder)builder).shards, "_shards");
        this.suggest = ModelTypeHelper.unmodifiable(((Builder)builder).suggest);
        this.terminatedEarly = ((Builder)builder).terminatedEarly;
        this.timedOut = Objects.requireNonNull(((Builder)builder).timedOut, "timed_out");
        this.took = Objects.requireNonNull(((Builder)builder).took, "took");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public AsyncSearch(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, JsonValue> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public ClusterStatistics clusters() {
        return this.clusters;
    }

    @Nullable
    public Map<String, JsonData> fields() {
        return this.fields;
    }

    public HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    @Nullable
    public Double maxScore() {
        return this.maxScore;
    }

    @Nullable
    public Long numReducePhases() {
        return this.numReducePhases;
    }

    @Nullable
    public Profile profile() {
        return this.profile;
    }

    @Nullable
    public String pitId() {
        return this.pitId;
    }

    @Nullable
    public String scrollId() {
        return this.scrollId;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public Map<String, List<Suggestion<TDocument>>> suggest() {
        return this.suggest;
    }

    @Nullable
    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public long took() {
        return this.took;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, JsonValue> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.clusters != null) {
            generator.writeKey("_clusters");
            this.clusters.serialize(generator, mapper);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
        if (this.numReducePhases != null) {
            generator.writeKey("num_reduce_phases");
            generator.write(this.numReducePhases.longValue());
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            this.profile.serialize(generator, mapper);
        }
        if (this.pitId != null) {
            generator.writeKey("pit_id");
            generator.write(this.pitId);
        }
        if (this.scrollId != null) {
            generator.writeKey("_scroll_id");
            generator.write(this.scrollId);
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        if (this.suggest != null) {
            generator.writeKey("suggest");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.suggest.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                for (Suggestion item1 : (List)entry.getValue()) {
                    item1.serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly.booleanValue());
        }
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("took");
        generator.write(this.took);
    }

    public static <TDocument> JsonpDeserializer<AsyncSearch<TDocument>> createAsyncSearchDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> AsyncSearch.setupAsyncSearchDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupAsyncSearchDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.jsonValueDeserializer()), "aggregations", new String[0]);
        op.add(Builder::clusters, ClusterStatistics._DESERIALIZER, "_clusters", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields", new String[0]);
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits", new String[0]);
        op.add(Builder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score", new String[0]);
        op.add(Builder::numReducePhases, JsonpDeserializer.longDeserializer(), "num_reduce_phases", new String[0]);
        op.add(Builder::profile, Profile._DESERIALIZER, "profile", new String[0]);
        op.add(Builder::pitId, JsonpDeserializer.stringDeserializer(), "pit_id", new String[0]);
        op.add(Builder::scrollId, JsonpDeserializer.stringDeserializer(), "_scroll_id", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::suggest, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(Suggestion.createSuggestionDeserializer(tDocumentDeserializer))), "suggest", new String[0]);
        op.add(Builder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early", new String[0]);
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<AsyncSearch<TDocument>> {
        @Nullable
        private Map<String, JsonValue> aggregations;
        @Nullable
        private ClusterStatistics clusters;
        @Nullable
        private Map<String, JsonData> fields;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Double maxScore;
        @Nullable
        private Long numReducePhases;
        @Nullable
        private Profile profile;
        @Nullable
        private String pitId;
        @Nullable
        private String scrollId;
        private ShardStatistics shards;
        @Nullable
        private Map<String, List<Suggestion<TDocument>>> suggest;
        @Nullable
        private Boolean terminatedEarly;
        private Boolean timedOut;
        private Long took;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> aggregations(@Nullable Map<String, JsonValue> value) {
            this.aggregations = value;
            return this;
        }

        public Builder<TDocument> putAggregations(String key, JsonValue value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, JsonValue>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        public Builder<TDocument> clusters(@Nullable ClusterStatistics value) {
            this.clusters = value;
            return this;
        }

        public Builder<TDocument> clusters(Function<ClusterStatistics.Builder, ObjectBuilder<ClusterStatistics>> fn) {
            return this.clusters(fn.apply(new ClusterStatistics.Builder()).build());
        }

        public Builder<TDocument> fields(@Nullable Map<String, JsonData> value) {
            this.fields = value;
            return this;
        }

        public Builder<TDocument> putFields(String key, JsonData value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, JsonData>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder<TDocument> hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this;
        }

        public Builder<TDocument> hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public Builder<TDocument> maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this;
        }

        public Builder<TDocument> numReducePhases(@Nullable Long value) {
            this.numReducePhases = value;
            return this;
        }

        public Builder<TDocument> profile(@Nullable Profile value) {
            this.profile = value;
            return this;
        }

        public Builder<TDocument> profile(Function<Profile.Builder, ObjectBuilder<Profile>> fn) {
            return this.profile(fn.apply(new Profile.Builder()).build());
        }

        public Builder<TDocument> pitId(@Nullable String value) {
            this.pitId = value;
            return this;
        }

        public Builder<TDocument> scrollId(@Nullable String value) {
            this.scrollId = value;
            return this;
        }

        public Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder<TDocument> suggest(@Nullable Map<String, List<Suggestion<TDocument>>> value) {
            this.suggest = value;
            return this;
        }

        public Builder<TDocument> putSuggest(String key, List<Suggestion<TDocument>> value) {
            if (this.suggest == null) {
                this.suggest = new HashMap<String, List<Suggestion<TDocument>>>();
            }
            this.suggest.put(key, value);
            return this;
        }

        public Builder<TDocument> terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return this;
        }

        public Builder<TDocument> timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public Builder<TDocument> took(long value) {
            this.took = value;
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public AsyncSearch<TDocument> build() {
            return new AsyncSearch(this);
        }
    }
}

