/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TermsSetQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final String minimumShouldMatchField;
    @Nullable
    private final JsonValue minimumShouldMatchScript;
    private final List<String> terms;
    public static final JsonpDeserializer<TermsSetQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsSetQuery::setupTermsSetQueryDeserializer, Builder::build);

    public TermsSetQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.minimumShouldMatchField = builder.minimumShouldMatchField;
        this.minimumShouldMatchScript = builder.minimumShouldMatchScript;
        this.terms = ModelTypeHelper.unmodifiableNonNull(builder.terms, "terms");
    }

    public TermsSetQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "terms_set";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String minimumShouldMatchField() {
        return this.minimumShouldMatchField;
    }

    @Nullable
    public JsonValue minimumShouldMatchScript() {
        return this.minimumShouldMatchScript;
    }

    public List<String> terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.minimumShouldMatchField != null) {
            generator.writeKey("minimum_should_match_field");
            generator.write(this.minimumShouldMatchField);
        }
        if (this.minimumShouldMatchScript != null) {
            generator.writeKey("minimum_should_match_script");
            generator.write(this.minimumShouldMatchScript);
        }
        generator.writeKey("terms");
        generator.writeStartArray();
        for (String item0 : this.terms) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeEnd();
    }

    protected static void setupTermsSetQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::minimumShouldMatchField, JsonpDeserializer.stringDeserializer(), "minimum_should_match_field", new String[0]);
        op.add(Builder::minimumShouldMatchScript, JsonpDeserializer.jsonValueDeserializer(), "minimum_should_match_script", new String[0]);
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "terms", new String[0]);
        op.setKey(Builder::field);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermsSetQuery> {
        private String field;
        @Nullable
        private String minimumShouldMatchField;
        @Nullable
        private JsonValue minimumShouldMatchScript;
        private List<String> terms;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder minimumShouldMatchField(@Nullable String value) {
            this.minimumShouldMatchField = value;
            return this;
        }

        public Builder minimumShouldMatchScript(@Nullable JsonValue value) {
            this.minimumShouldMatchScript = value;
            return this;
        }

        public Builder terms(List<String> value) {
            this.terms = value;
            return this;
        }

        public Builder terms(String ... value) {
            this.terms = Arrays.asList(value);
            return this;
        }

        public Builder addTerms(String value) {
            if (this.terms == null) {
                this.terms = new ArrayList<String>();
            }
            this.terms.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsSetQuery build() {
            return new TermsSetQuery(this);
        }
    }
}

