/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class SpanOrQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final List<SpanQuery> clauses;
    public static final JsonpDeserializer<SpanOrQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanOrQuery::setupSpanOrQueryDeserializer, Builder::build);

    public SpanOrQuery(Builder builder) {
        super(builder);
        this.clauses = ModelTypeHelper.unmodifiableNonNull(builder.clauses, "clauses");
    }

    public SpanOrQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "span_or";
    }

    public List<SpanQuery> clauses() {
        return this.clauses;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("clauses");
        generator.writeStartArray();
        for (SpanQuery item0 : this.clauses) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSpanOrQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::clauses, JsonpDeserializer.arrayDeserializer(SpanQuery._DESERIALIZER), "clauses", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanOrQuery> {
        private List<SpanQuery> clauses;

        public Builder clauses(List<SpanQuery> value) {
            this.clauses = value;
            return this;
        }

        public Builder clauses(SpanQuery ... value) {
            this.clauses = Arrays.asList(value);
            return this;
        }

        public Builder addClauses(SpanQuery value) {
            if (this.clauses == null) {
                this.clauses = new ArrayList<SpanQuery>();
            }
            this.clauses.add(value);
            return this;
        }

        public Builder clauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.clauses(fn.apply(new SpanQuery.Builder()).build());
        }

        public Builder addClauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.addClauses(fn.apply(new SpanQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanOrQuery build() {
            return new SpanOrQuery(this);
        }
    }
}

