/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PercolateQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final JsonData document;
    @Nullable
    private final List<JsonData> documents;
    private final String field;
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final String name;
    @Nullable
    private final String preference;
    @Nullable
    private final String routing;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PercolateQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercolateQuery::setupPercolateQueryDeserializer, Builder::build);

    public PercolateQuery(Builder builder) {
        super(builder);
        this.document = builder.document;
        this.documents = ModelTypeHelper.unmodifiable(builder.documents);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.id = builder.id;
        this.index = builder.index;
        this.name = builder.name;
        this.preference = builder.preference;
        this.routing = builder.routing;
        this.version = builder.version;
    }

    public PercolateQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "percolate";
    }

    @Nullable
    public JsonData document() {
        return this.document;
    }

    @Nullable
    public List<JsonData> documents() {
        return this.documents;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.document != null) {
            generator.writeKey("document");
            this.document.serialize(generator, mapper);
        }
        if (this.documents != null) {
            generator.writeKey("documents");
            generator.writeStartArray();
            for (JsonData item0 : this.documents) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.preference != null) {
            generator.writeKey("preference");
            generator.write(this.preference);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupPercolateQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::document, JsonData._DESERIALIZER, "document", new String[0]);
        op.add(Builder::documents, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "documents", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::preference, JsonpDeserializer.stringDeserializer(), "preference", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PercolateQuery> {
        @Nullable
        private JsonData document;
        @Nullable
        private List<JsonData> documents;
        private String field;
        @Nullable
        private String id;
        @Nullable
        private String index;
        @Nullable
        private String name;
        @Nullable
        private String preference;
        @Nullable
        private String routing;
        @Nullable
        private Long version;

        public Builder document(@Nullable JsonData value) {
            this.document = value;
            return this;
        }

        public Builder documents(@Nullable List<JsonData> value) {
            this.documents = value;
            return this;
        }

        public Builder documents(JsonData ... value) {
            this.documents = Arrays.asList(value);
            return this;
        }

        public Builder addDocuments(JsonData value) {
            if (this.documents == null) {
                this.documents = new ArrayList<JsonData>();
            }
            this.documents.add(value);
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PercolateQuery build() {
            return new PercolateQuery(this);
        }
    }
}

