/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SimpleAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final String version;
    public static final JsonpDeserializer<SimpleAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimpleAnalyzer::setupSimpleAnalyzerDeserializer, Builder::build);

    public SimpleAnalyzer(Builder builder) {
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public SimpleAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "simple";
    }

    public String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "simple");
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupSimpleAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<SimpleAnalyzer> {
        private String version;

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        public SimpleAnalyzer build() {
            return new SimpleAnalyzer(this);
        }
    }
}

