/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.Language;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class LanguageAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final String version;
    private final Language language;
    private final List<String> stemExclusion;
    private final List<String> stopwords;
    private final String stopwordsPath;
    public static final JsonpDeserializer<LanguageAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LanguageAnalyzer::setupLanguageAnalyzerDeserializer, Builder::build);

    public LanguageAnalyzer(Builder builder) {
        this.version = Objects.requireNonNull(builder.version, "version");
        this.language = Objects.requireNonNull(builder.language, "language");
        this.stemExclusion = ModelTypeHelper.unmodifiableNonNull(builder.stemExclusion, "stem_exclusion");
        this.stopwords = ModelTypeHelper.unmodifiableNonNull(builder.stopwords, "stopwords");
        this.stopwordsPath = Objects.requireNonNull(builder.stopwordsPath, "stopwords_path");
    }

    public LanguageAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "language";
    }

    public String version() {
        return this.version;
    }

    public Language language() {
        return this.language;
    }

    public List<String> stemExclusion() {
        return this.stemExclusion;
    }

    public List<String> stopwords() {
        return this.stopwords;
    }

    public String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "language");
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
        generator.writeKey("stem_exclusion");
        generator.writeStartArray();
        for (String item0 : this.stemExclusion) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("stopwords");
        generator.writeStartArray();
        for (String item0 : this.stopwords) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("stopwords_path");
        generator.write(this.stopwordsPath);
    }

    protected static void setupLanguageAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::language, Language._DESERIALIZER, "language", new String[0]);
        op.add(Builder::stemExclusion, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stem_exclusion", new String[0]);
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords", new String[0]);
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<LanguageAnalyzer> {
        private String version;
        private Language language;
        private List<String> stemExclusion;
        private List<String> stopwords;
        private String stopwordsPath;

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder language(Language value) {
            this.language = value;
            return this;
        }

        public Builder stemExclusion(List<String> value) {
            this.stemExclusion = value;
            return this;
        }

        public Builder stemExclusion(String ... value) {
            this.stemExclusion = Arrays.asList(value);
            return this;
        }

        public Builder addStemExclusion(String value) {
            if (this.stemExclusion == null) {
                this.stemExclusion = new ArrayList<String>();
            }
            this.stemExclusion.add(value);
            return this;
        }

        public Builder stopwords(List<String> value) {
            this.stopwords = value;
            return this;
        }

        public Builder stopwords(String ... value) {
            this.stopwords = Arrays.asList(value);
            return this;
        }

        public Builder addStopwords(String value) {
            if (this.stopwords == null) {
                this.stopwords = new ArrayList<String>();
            }
            this.stopwords.add(value);
            return this;
        }

        public Builder stopwordsPath(String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        public LanguageAnalyzer build() {
            return new LanguageAnalyzer(this);
        }
    }
}

