/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KuromojiStemmerTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final int minimumLength;
    public static final JsonpDeserializer<KuromojiStemmerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiStemmerTokenFilter::setupKuromojiStemmerTokenFilterDeserializer, Builder::build);

    public KuromojiStemmerTokenFilter(Builder builder) {
        super(builder);
        this.minimumLength = Objects.requireNonNull(builder.minimumLength, "minimum_length");
    }

    public KuromojiStemmerTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "kuromoji_stemmer";
    }

    public int minimumLength() {
        return this.minimumLength;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_stemmer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("minimum_length");
        generator.write(this.minimumLength);
    }

    protected static void setupKuromojiStemmerTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::minimumLength, JsonpDeserializer.integerDeserializer(), "minimum_length", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiStemmerTokenFilter> {
        private Integer minimumLength;

        public Builder minimumLength(int value) {
            this.minimumLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiStemmerTokenFilter build() {
            return new KuromojiStemmerTokenFilter(this);
        }
    }
}

