/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.DelimitedPayloadEncoding;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DelimitedPayloadTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final String delimiter;
    private final DelimitedPayloadEncoding encoding;
    public static final JsonpDeserializer<DelimitedPayloadTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelimitedPayloadTokenFilter::setupDelimitedPayloadTokenFilterDeserializer, Builder::build);

    public DelimitedPayloadTokenFilter(Builder builder) {
        super(builder);
        this.delimiter = Objects.requireNonNull(builder.delimiter, "delimiter");
        this.encoding = Objects.requireNonNull(builder.encoding, "encoding");
    }

    public DelimitedPayloadTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "delimited_payload";
    }

    public String delimiter() {
        return this.delimiter;
    }

    public DelimitedPayloadEncoding encoding() {
        return this.encoding;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "delimited_payload");
        super.serializeInternal(generator, mapper);
        generator.writeKey("delimiter");
        generator.write(this.delimiter);
        generator.writeKey("encoding");
        this.encoding.serialize(generator, mapper);
    }

    protected static void setupDelimitedPayloadTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter", new String[0]);
        op.add(Builder::encoding, DelimitedPayloadEncoding._DESERIALIZER, "encoding", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DelimitedPayloadTokenFilter> {
        private String delimiter;
        private DelimitedPayloadEncoding encoding;

        public Builder delimiter(String value) {
            this.delimiter = value;
            return this;
        }

        public Builder encoding(DelimitedPayloadEncoding value) {
            this.encoding = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DelimitedPayloadTokenFilter build() {
            return new DelimitedPayloadTokenFilter(this);
        }
    }
}

