/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class CharGroupTokenizer
extends TokenizerBase
implements TokenizerVariant {
    private final List<String> tokenizeOnChars;
    public static final JsonpDeserializer<CharGroupTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharGroupTokenizer::setupCharGroupTokenizerDeserializer, Builder::build);

    public CharGroupTokenizer(Builder builder) {
        super(builder);
        this.tokenizeOnChars = ModelTypeHelper.unmodifiableNonNull(builder.tokenizeOnChars, "tokenize_on_chars");
    }

    public CharGroupTokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "char_group";
    }

    public List<String> tokenizeOnChars() {
        return this.tokenizeOnChars;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "char_group");
        super.serializeInternal(generator, mapper);
        generator.writeKey("tokenize_on_chars");
        generator.writeStartArray();
        for (String item0 : this.tokenizeOnChars) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupCharGroupTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::tokenizeOnChars, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tokenize_on_chars", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CharGroupTokenizer> {
        private List<String> tokenizeOnChars;

        public Builder tokenizeOnChars(List<String> value) {
            this.tokenizeOnChars = value;
            return this;
        }

        public Builder tokenizeOnChars(String ... value) {
            this.tokenizeOnChars = Arrays.asList(value);
            return this;
        }

        public Builder addTokenizeOnChars(String value) {
            if (this.tokenizeOnChars == null) {
                this.tokenizeOnChars = new ArrayList<String>();
            }
            this.tokenizeOnChars.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CharGroupTokenizer build() {
            return new CharGroupTokenizer(this);
        }
    }
}

