/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SerialDifferencingAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer lag;
    public static final JsonpDeserializer<SerialDifferencingAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SerialDifferencingAggregation::setupSerialDifferencingAggregationDeserializer, Builder::build);

    public SerialDifferencingAggregation(Builder builder) {
        super(builder);
        this.lag = builder.lag;
    }

    public SerialDifferencingAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "serial_diff";
    }

    @Nullable
    public Integer lag() {
        return this.lag;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lag != null) {
            generator.writeKey("lag");
            generator.write(this.lag.intValue());
        }
    }

    protected static void setupSerialDifferencingAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::lag, JsonpDeserializer.integerDeserializer(), "lag", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SerialDifferencingAggregation> {
        @Nullable
        private Integer lag;

        public Builder lag(@Nullable Integer value) {
            this.lag = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SerialDifferencingAggregation build() {
            return new SerialDifferencingAggregation(this);
        }
    }
}

