/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationRange;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RangeAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String field;
    @Nullable
    private final List<AggregationRange> ranges;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<RangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeAggregation::setupRangeAggregationDeserializer, Builder::build);

    public RangeAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.ranges = ModelTypeHelper.unmodifiable(builder.ranges);
        this.script = builder.script;
        this.keyed = builder.keyed;
    }

    public RangeAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "range";
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public List<AggregationRange> ranges() {
        return this.ranges;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.ranges != null) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (AggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    protected static void setupRangeAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(AggregationRange._DESERIALIZER), "ranges", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private List<AggregationRange> ranges;
        @Nullable
        private JsonValue script;
        @Nullable
        private Boolean keyed;

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder ranges(@Nullable List<AggregationRange> value) {
            this.ranges = value;
            return this;
        }

        public Builder ranges(AggregationRange ... value) {
            this.ranges = Arrays.asList(value);
            return this;
        }

        public Builder addRanges(AggregationRange value) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<AggregationRange>();
            }
            this.ranges.add(value);
            return this;
        }

        public Builder ranges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.ranges(fn.apply(new AggregationRange.Builder()).build());
        }

        public Builder addRanges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.addRanges(fn.apply(new AggregationRange.Builder()).build());
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RangeAggregation build() {
            return new RangeAggregation(this);
        }
    }
}

