/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.FormatMetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.HdrMethod;
import co.elastic.clients.elasticsearch._types.aggregations.TDigest;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PercentileRanksAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean keyed;
    @Nullable
    private final List<Double> values;
    @Nullable
    private final HdrMethod hdr;
    @Nullable
    private final TDigest tdigest;
    public static final JsonpDeserializer<PercentileRanksAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentileRanksAggregation::setupPercentileRanksAggregationDeserializer, Builder::build);

    public PercentileRanksAggregation(Builder builder) {
        super(builder);
        this.keyed = builder.keyed;
        this.values = ModelTypeHelper.unmodifiable(builder.values);
        this.hdr = builder.hdr;
        this.tdigest = builder.tdigest;
    }

    public PercentileRanksAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "percentile_ranks";
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Nullable
    public List<Double> values() {
        return this.values;
    }

    @Nullable
    public HdrMethod hdr() {
        return this.hdr;
    }

    @Nullable
    public TDigest tdigest() {
        return this.tdigest;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (this.values != null) {
            generator.writeKey("values");
            generator.writeStartArray();
            for (Double item0 : this.values) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
        if (this.hdr != null) {
            generator.writeKey("hdr");
            this.hdr.serialize(generator, mapper);
        }
        if (this.tdigest != null) {
            generator.writeKey("tdigest");
            this.tdigest.serialize(generator, mapper);
        }
    }

    protected static void setupPercentileRanksAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        FormatMetricAggregationBase.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
        op.add(Builder::values, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "values", new String[0]);
        op.add(Builder::hdr, HdrMethod._DESERIALIZER, "hdr", new String[0]);
        op.add(Builder::tdigest, TDigest._DESERIALIZER, "tdigest", new String[0]);
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PercentileRanksAggregation> {
        @Nullable
        private Boolean keyed;
        @Nullable
        private List<Double> values;
        @Nullable
        private HdrMethod hdr;
        @Nullable
        private TDigest tdigest;

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        public Builder values(@Nullable List<Double> value) {
            this.values = value;
            return this;
        }

        public Builder values(Double ... value) {
            this.values = Arrays.asList(value);
            return this;
        }

        public Builder addValues(Double value) {
            if (this.values == null) {
                this.values = new ArrayList<Double>();
            }
            this.values.add(value);
            return this;
        }

        public Builder hdr(@Nullable HdrMethod value) {
            this.hdr = value;
            return this;
        }

        public Builder hdr(Function<HdrMethod.Builder, ObjectBuilder<HdrMethod>> fn) {
            return this.hdr(fn.apply(new HdrMethod.Builder()).build());
        }

        public Builder tdigest(@Nullable TDigest value) {
            this.tdigest = value;
            return this;
        }

        public Builder tdigest(Function<TDigest.Builder, ObjectBuilder<TDigest>> fn) {
            return this.tdigest(fn.apply(new TDigest.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PercentileRanksAggregation build() {
            return new PercentileRanksAggregation(this);
        }
    }
}

