/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermLookup;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class MultiTermsAggregation
extends BucketAggregationBase
implements AggregationVariant {
    private final List<MultiTermLookup> terms;
    public static final JsonpDeserializer<MultiTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermsAggregation::setupMultiTermsAggregationDeserializer, Builder::build);

    public MultiTermsAggregation(Builder builder) {
        super(builder);
        this.terms = ModelTypeHelper.unmodifiableNonNull(builder.terms, "terms");
    }

    public MultiTermsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "multi_terms";
    }

    public List<MultiTermLookup> terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("terms");
        generator.writeStartArray();
        for (MultiTermLookup item0 : this.terms) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupMultiTermsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(MultiTermLookup._DESERIALIZER), "terms", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiTermsAggregation> {
        private List<MultiTermLookup> terms;

        public Builder terms(List<MultiTermLookup> value) {
            this.terms = value;
            return this;
        }

        public Builder terms(MultiTermLookup ... value) {
            this.terms = Arrays.asList(value);
            return this;
        }

        public Builder addTerms(MultiTermLookup value) {
            if (this.terms == null) {
                this.terms = new ArrayList<MultiTermLookup>();
            }
            this.terms.add(value);
            return this;
        }

        public Builder terms(Function<MultiTermLookup.Builder, ObjectBuilder<MultiTermLookup>> fn) {
            return this.terms(fn.apply(new MultiTermLookup.Builder()).build());
        }

        public Builder addTerms(Function<MultiTermLookup.Builder, ObjectBuilder<MultiTermLookup>> fn) {
            return this.addTerms(fn.apply(new MultiTermLookup.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiTermsAggregation build() {
            return new MultiTermsAggregation(this);
        }
    }
}

