/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DateRangeExpression
implements JsonpSerializable {
    @Nullable
    private final JsonValue from;
    @Nullable
    private final String fromAsString;
    @Nullable
    private final String toAsString;
    @Nullable
    private final String key;
    @Nullable
    private final JsonValue to;
    @Nullable
    private final Long docCount;
    public static final JsonpDeserializer<DateRangeExpression> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateRangeExpression::setupDateRangeExpressionDeserializer, Builder::build);

    public DateRangeExpression(Builder builder) {
        this.from = builder.from;
        this.fromAsString = builder.fromAsString;
        this.toAsString = builder.toAsString;
        this.key = builder.key;
        this.to = builder.to;
        this.docCount = builder.docCount;
    }

    public DateRangeExpression(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public JsonValue from() {
        return this.from;
    }

    @Nullable
    public String fromAsString() {
        return this.fromAsString;
    }

    @Nullable
    public String toAsString() {
        return this.toAsString;
    }

    @Nullable
    public String key() {
        return this.key;
    }

    @Nullable
    public JsonValue to() {
        return this.to;
    }

    @Nullable
    public Long docCount() {
        return this.docCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from);
        }
        if (this.fromAsString != null) {
            generator.writeKey("from_as_string");
            generator.write(this.fromAsString);
        }
        if (this.toAsString != null) {
            generator.writeKey("to_as_string");
            generator.write(this.toAsString);
        }
        if (this.key != null) {
            generator.writeKey("key");
            generator.write(this.key);
        }
        if (this.to != null) {
            generator.writeKey("to");
            generator.write(this.to);
        }
        if (this.docCount != null) {
            generator.writeKey("doc_count");
            generator.write(this.docCount.longValue());
        }
    }

    protected static void setupDateRangeExpressionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::from, JsonpDeserializer.jsonValueDeserializer(), "from", new String[0]);
        op.add(Builder::fromAsString, JsonpDeserializer.stringDeserializer(), "from_as_string", new String[0]);
        op.add(Builder::toAsString, JsonpDeserializer.stringDeserializer(), "to_as_string", new String[0]);
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key", new String[0]);
        op.add(Builder::to, JsonpDeserializer.jsonValueDeserializer(), "to", new String[0]);
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DateRangeExpression> {
        @Nullable
        private JsonValue from;
        @Nullable
        private String fromAsString;
        @Nullable
        private String toAsString;
        @Nullable
        private String key;
        @Nullable
        private JsonValue to;
        @Nullable
        private Long docCount;

        public Builder from(@Nullable JsonValue value) {
            this.from = value;
            return this;
        }

        public Builder fromAsString(@Nullable String value) {
            this.fromAsString = value;
            return this;
        }

        public Builder toAsString(@Nullable String value) {
            this.toAsString = value;
            return this;
        }

        public Builder key(@Nullable String value) {
            this.key = value;
            return this;
        }

        public Builder to(@Nullable JsonValue value) {
            this.to = value;
            return this;
        }

        public Builder docCount(@Nullable Long value) {
            this.docCount = value;
            return this;
        }

        @Override
        public DateRangeExpression build() {
            return new DateRangeExpression(this);
        }
    }
}

