/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSourceVariant;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedBounds;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramOrder;
import co.elastic.clients.elasticsearch.transform.PivotGroupByVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DateHistogramAggregation
extends BucketAggregationBase
implements AggregationVariant,
PivotGroupByVariant,
CompositeAggregationSourceVariant {
    @Nullable
    private final JsonValue calendarInterval;
    @Nullable
    private final ExtendedBounds<JsonValue> extendedBounds;
    @Nullable
    private final ExtendedBounds<JsonValue> hardBounds;
    @Nullable
    private final String field;
    @Nullable
    private final JsonValue fixedInterval;
    @Nullable
    private final String format;
    @Nullable
    private final JsonValue interval;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final String missing;
    @Nullable
    private final String offset;
    @Nullable
    private final HistogramOrder order;
    @Nullable
    private final Map<String, JsonData> params;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final String timeZone;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<DateHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateHistogramAggregation::setupDateHistogramAggregationDeserializer, Builder::build);

    public DateHistogramAggregation(Builder builder) {
        super(builder);
        this.calendarInterval = builder.calendarInterval;
        this.extendedBounds = builder.extendedBounds;
        this.hardBounds = builder.hardBounds;
        this.field = builder.field;
        this.fixedInterval = builder.fixedInterval;
        this.format = builder.format;
        this.interval = builder.interval;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.offset = builder.offset;
        this.order = builder.order;
        this.params = ModelTypeHelper.unmodifiable(builder.params);
        this.script = builder.script;
        this.timeZone = builder.timeZone;
        this.keyed = builder.keyed;
    }

    public DateHistogramAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "date_histogram";
    }

    @Nullable
    public JsonValue calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public ExtendedBounds<JsonValue> extendedBounds() {
        return this.extendedBounds;
    }

    @Nullable
    public ExtendedBounds<JsonValue> hardBounds() {
        return this.hardBounds;
    }

    @Nullable
    public String field() {
        return this.field;
    }

    @Nullable
    public JsonValue fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public JsonValue interval() {
        return this.interval;
    }

    @Nullable
    public Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public String missing() {
        return this.missing;
    }

    @Nullable
    public String offset() {
        return this.offset;
    }

    @Nullable
    public HistogramOrder order() {
        return this.order;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            generator.write(this.calendarInterval);
        }
        if (this.extendedBounds != null) {
            generator.writeKey("extended_bounds");
            this.extendedBounds.serialize(generator, mapper);
        }
        if (this.hardBounds != null) {
            generator.writeKey("hard_bounds");
            this.hardBounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.fixedInterval != null) {
            generator.writeKey("fixed_interval");
            generator.write(this.fixedInterval);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            generator.write(this.interval);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            generator.write(this.offset);
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    protected static void setupDateHistogramAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::calendarInterval, JsonpDeserializer.jsonValueDeserializer(), "calendar_interval", new String[0]);
        op.add(Builder::extendedBounds, ExtendedBounds.createExtendedBoundsDeserializer(JsonpDeserializer.jsonValueDeserializer()), "extended_bounds", new String[0]);
        op.add(Builder::hardBounds, ExtendedBounds.createExtendedBoundsDeserializer(JsonpDeserializer.jsonValueDeserializer()), "hard_bounds", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::fixedInterval, JsonpDeserializer.jsonValueDeserializer(), "fixed_interval", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::interval, JsonpDeserializer.jsonValueDeserializer(), "interval", new String[0]);
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count", new String[0]);
        op.add(Builder::missing, JsonpDeserializer.stringDeserializer(), "missing", new String[0]);
        op.add(Builder::offset, JsonpDeserializer.stringDeserializer(), "offset", new String[0]);
        op.add(Builder::order, HistogramOrder._DESERIALIZER, "order", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone", new String[0]);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateHistogramAggregation> {
        @Nullable
        private JsonValue calendarInterval;
        @Nullable
        private ExtendedBounds<JsonValue> extendedBounds;
        @Nullable
        private ExtendedBounds<JsonValue> hardBounds;
        @Nullable
        private String field;
        @Nullable
        private JsonValue fixedInterval;
        @Nullable
        private String format;
        @Nullable
        private JsonValue interval;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private String missing;
        @Nullable
        private String offset;
        @Nullable
        private HistogramOrder order;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private JsonValue script;
        @Nullable
        private String timeZone;
        @Nullable
        private Boolean keyed;

        public Builder calendarInterval(@Nullable JsonValue value) {
            this.calendarInterval = value;
            return this;
        }

        public Builder extendedBounds(@Nullable ExtendedBounds<JsonValue> value) {
            this.extendedBounds = value;
            return this;
        }

        public Builder extendedBounds(Function<ExtendedBounds.Builder<JsonValue>, ObjectBuilder<ExtendedBounds<JsonValue>>> fn) {
            return this.extendedBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public Builder hardBounds(@Nullable ExtendedBounds<JsonValue> value) {
            this.hardBounds = value;
            return this;
        }

        public Builder hardBounds(Function<ExtendedBounds.Builder<JsonValue>, ObjectBuilder<ExtendedBounds<JsonValue>>> fn) {
            return this.hardBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public Builder fixedInterval(@Nullable JsonValue value) {
            this.fixedInterval = value;
            return this;
        }

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder interval(@Nullable JsonValue value) {
            this.interval = value;
            return this;
        }

        public Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        public Builder missing(@Nullable String value) {
            this.missing = value;
            return this;
        }

        public Builder offset(@Nullable String value) {
            this.offset = value;
            return this;
        }

        public Builder order(@Nullable HistogramOrder value) {
            this.order = value;
            return this;
        }

        public Builder order(Function<HistogramOrder.Builder, ObjectBuilder<HistogramOrder>> fn) {
            return this.order(fn.apply(new HistogramOrder.Builder()).build());
        }

        public Builder params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        public Builder script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateHistogramAggregation build() {
            return new DateHistogramAggregation(this);
        }
    }
}

