/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MainError
extends ErrorCause {
    @Nullable
    private final Map<String, String> headers;
    public static final JsonpDeserializer<MainError> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MainError::setupMainErrorDeserializer, Builder::build);

    public MainError(Builder builder) {
        super(builder);
        this.headers = ModelTypeHelper.unmodifiable(builder.headers);
    }

    public MainError(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.headers != null) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupMainErrorDeserializer(DelegatingDeserializer<Builder> op) {
        ErrorCause.setupErrorCauseDeserializer(op);
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "headers", new String[0]);
    }

    public static class Builder
    extends ErrorCause.AbstractBuilder<Builder>
    implements ObjectBuilder<MainError> {
        @Nullable
        private Map<String, String> headers;

        public Builder headers(@Nullable Map<String, String> value) {
            this.headers = value;
            return this;
        }

        public Builder putHeaders(String key, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MainError build() {
            return new MainError(this);
        }
    }
}

