/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.FieldSizeUsage;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CompletionStats
implements JsonpSerializable {
    private final long sizeInBytes;
    @Nullable
    private final String size;
    @Nullable
    private final Map<String, FieldSizeUsage> fields;
    public static final JsonpDeserializer<CompletionStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionStats::setupCompletionStatsDeserializer, Builder::build);

    public CompletionStats(Builder builder) {
        this.sizeInBytes = Objects.requireNonNull(builder.sizeInBytes, "size_in_bytes");
        this.size = builder.size;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
    }

    public CompletionStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Nullable
    public String size() {
        return this.size;
    }

    @Nullable
    public Map<String, FieldSizeUsage> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, FieldSizeUsage> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCompletionStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes", new String[0]);
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(FieldSizeUsage._DESERIALIZER), "fields", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CompletionStats> {
        private Long sizeInBytes;
        @Nullable
        private String size;
        @Nullable
        private Map<String, FieldSizeUsage> fields;

        public Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public Builder fields(@Nullable Map<String, FieldSizeUsage> value) {
            this.fields = value;
            return this;
        }

        public Builder putFields(String key, FieldSizeUsage value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, FieldSizeUsage>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder fields(String key, Function<FieldSizeUsage.Builder, ObjectBuilder<FieldSizeUsage>> fn) {
            return this.fields(Collections.singletonMap(key, fn.apply(new FieldSizeUsage.Builder()).build()));
        }

        public Builder putFields(String key, Function<FieldSizeUsage.Builder, ObjectBuilder<FieldSizeUsage>> fn) {
            return this.putFields(key, fn.apply(new FieldSizeUsage.Builder()).build());
        }

        @Override
        public CompletionStats build() {
            return new CompletionStats(this);
        }
    }
}

