/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.elasticsearch._core.search.CompletionSuggester;
import co.elastic.clients.elasticsearch._core.search.PhraseSuggester;
import co.elastic.clients.elasticsearch._core.search.SuggestVariant;
import co.elastic.clients.elasticsearch._core.search.TermSuggester;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Suggest
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String COMPLETION = "completion";
    public static final String PHRASE = "phrase";
    public static final String PREFIX = "prefix";
    public static final String REGEX = "regex";
    public static final String TERM = "term";
    public static final String TEXT = "text";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Suggest> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Suggest::setupSuggestDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Suggest(SuggestVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends SuggestVariant> Suggest(ObjectBuilder<T> builder) {
        this((SuggestVariant)builder.build());
    }

    private Suggest(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Suggest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public CompletionSuggester completion() {
        return (CompletionSuggester)TaggedUnionUtils.get(this, COMPLETION);
    }

    public PhraseSuggester phrase() {
        return (PhraseSuggester)TaggedUnionUtils.get(this, PHRASE);
    }

    public String prefix() {
        return (String)TaggedUnionUtils.get(this, PREFIX);
    }

    public String regex() {
        return (String)TaggedUnionUtils.get(this, REGEX);
    }

    public TermSuggester term() {
        return (TermSuggester)TaggedUnionUtils.get(this, TERM);
    }

    public String text() {
        return (String)TaggedUnionUtils.get(this, TEXT);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "prefix": {
                    generator.write((String)this._value);
                    break;
                }
                case "regex": {
                    generator.write((String)this._value);
                    break;
                }
                case "text": {
                    generator.write((String)this._value);
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupSuggestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::completion, CompletionSuggester._DESERIALIZER, COMPLETION, new String[0]);
        op.add(Builder::phrase, PhraseSuggester._DESERIALIZER, PHRASE, new String[0]);
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), PREFIX, new String[0]);
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), REGEX, new String[0]);
        op.add(Builder::term, TermSuggester._DESERIALIZER, TERM, new String[0]);
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), TEXT, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Suggest> {
        private String _type;
        private Object _value;

        public Builder completion(CompletionSuggester v) {
            this._type = Suggest.COMPLETION;
            this._value = v;
            return this;
        }

        public Builder completion(Function<CompletionSuggester.Builder, ObjectBuilder<CompletionSuggester>> f) {
            return this.completion(f.apply(new CompletionSuggester.Builder()).build());
        }

        public Builder phrase(PhraseSuggester v) {
            this._type = Suggest.PHRASE;
            this._value = v;
            return this;
        }

        public Builder phrase(Function<PhraseSuggester.Builder, ObjectBuilder<PhraseSuggester>> f) {
            return this.phrase(f.apply(new PhraseSuggester.Builder()).build());
        }

        public Builder prefix(String v) {
            this._type = Suggest.PREFIX;
            this._value = v;
            return this;
        }

        public Builder regex(String v) {
            this._type = Suggest.REGEX;
            this._value = v;
            return this;
        }

        public Builder term(TermSuggester v) {
            this._type = Suggest.TERM;
            this._value = v;
            return this;
        }

        public Builder term(Function<TermSuggester.Builder, ObjectBuilder<TermSuggester>> f) {
            return this.term(f.apply(new TermSuggester.Builder()).build());
        }

        public Builder text(String v) {
            this._type = Suggest.TEXT;
            this._value = v;
            return this;
        }

        @Override
        public Suggest build() {
            return new Suggest(this);
        }
    }
}

