/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.rank_eval;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RankEvalHit
implements JsonpSerializable {
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    private final double score;
    public static final JsonpDeserializer<RankEvalHit> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalHit::setupRankEvalHitDeserializer, Builder::build);

    public RankEvalHit(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.index = Objects.requireNonNull(builder.index, "_index");
        this.type = builder.type;
        this.score = Objects.requireNonNull(builder.score, "_score");
    }

    public RankEvalHit(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    public double score() {
        return this.score;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        generator.writeKey("_score");
        generator.write(this.score);
    }

    protected static void setupRankEvalHitDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "_score", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RankEvalHit> {
        private String id;
        private String index;
        @Nullable
        private String type;
        private Double score;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder score(double value) {
            this.score = value;
            return this;
        }

        @Override
        public RankEvalHit build() {
            return new RankEvalHit(this);
        }
    }
}

