/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j2;

import co.elastic.logging.log4j2.DefaultMdcSerializer;
import co.elastic.logging.log4j2.MdcSerializer;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.core.LogEvent;

class MdcSerializerResolver {
    MdcSerializerResolver() {
    }

    static MdcSerializer resolve(String mdcSerializerFullClassName) {
        if (mdcSerializerFullClassName == null || mdcSerializerFullClassName.isEmpty()) {
            return MdcSerializerResolver.resolveDefault();
        }
        try {
            Class<?> clazz = Class.forName(mdcSerializerFullClassName);
            return (MdcSerializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not create MdcSerializer " + mdcSerializerFullClassName, e);
        }
    }

    private static MdcSerializer resolveDefault() {
        try {
            LogEvent.class.getMethod("getContextData", new Class[0]);
            return (DefaultMdcSerializer)Class.forName("co.elastic.logging.log4j2.DefaultMdcSerializer$UsingContextData").getEnumConstants()[0];
        }
        catch (Exception | LinkageError throwable) {
            return DefaultMdcSerializer.UsingContextMap.INSTANCE;
        }
    }
}

