/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.agent.common.util.ProcessExecutionUtil;
import co.elastic.apm.attach.AgentDownloadUtils;
import co.elastic.apm.attach.AgentDownloader;
import co.elastic.apm.attach.DiscoveryRules;
import co.elastic.apm.attach.ElasticApmAttacher;
import co.elastic.apm.attach.GetAgentProperties;
import co.elastic.apm.attach.JvmDiscoverer;
import co.elastic.apm.attach.JvmInfo;
import co.elastic.apm.attach.PgpSignatureVerifier;
import co.elastic.apm.attach.PgpSignatureVerifierLoader;
import co.elastic.apm.attach.UserRegistry;
import co.elastic.logging.log4j2.EcsLayout;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;

public class AgentAttacher {
    public static final String LATEST_VERSION = "latest";
    private final Logger logger = LogManager.getLogger(AgentAttacher.class);
    private final Arguments arguments;
    private final Set<String> alreadySeenJvmPids = new HashSet<String>();
    private final UserRegistry userRegistry = UserRegistry.empty();

    private AgentAttacher(Arguments arguments) {
        this.arguments = arguments;
    }

    private static Logger initLogging(Arguments arguments) {
        PluginManager.addPackage(EcsLayout.class.getPackage().getName());
        PluginManager.addPackage(LoggerContext.class.getPackage().getName());
        ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        if (arguments.isLogToConsole()) {
            builder.add(((AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", ConsoleAppender.Target.SYSTEM_OUT)).add(AgentAttacher.getEcsLayout(builder)));
            builder.add((RootLoggerComponentBuilder)builder.newRootLogger(arguments.logLevel).add(builder.newAppenderRef("Stdout")));
        } else {
            builder.add((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("File", "RollingFile").addAttribute("fileName", arguments.getLogFile())).addAttribute("filePattern", arguments.getLogFile() + ".%i")).add(AgentAttacher.getEcsLayout(builder)).addComponent((ComponentBuilder<?>)builder.newComponent("Policies").addComponent((ComponentBuilder<?>)builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "10MB")))).addComponent((ComponentBuilder<?>)builder.newComponent("DefaultRolloverStrategy").addAttribute("max", 2)));
            builder.add((RootLoggerComponentBuilder)builder.newRootLogger(arguments.logLevel).add(builder.newAppenderRef("File")));
        }
        Configurator.initialize(AgentAttacher.class.getClassLoader(), (Configuration)builder.build());
        return LogManager.getLogger(AgentAttacher.class);
    }

    private static LayoutComponentBuilder getEcsLayout(ConfigurationBuilder<BuiltConfiguration> builder) {
        return (LayoutComponentBuilder)((LayoutComponentBuilder)builder.newLayout("EcsLayout").addAttribute("serviceName", "java-attacher")).addAttribute("eventDataset", "java-attacher.log");
    }

    public static void main(String[] args) {
        String downloadAgentVersion;
        Arguments arguments;
        try {
            arguments = Arguments.parse(args);
            if (arguments.isHelp()) {
                Arguments.printHelp(System.out);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            Arguments.printHelp(System.out);
            return;
        }
        Logger logger = AgentAttacher.initLogging(arguments);
        if (logger.isDebugEnabled()) {
            logger.debug("attach process started with:  user = '{}', current directory = {}", (Object)System.getProperty("user.name"), (Object)System.getProperty("user.dir"));
        }
        if ((downloadAgentVersion = arguments.getDownloadAgentVersion()) == null && arguments.getAgentJar() == null) {
            downloadAgentVersion = LATEST_VERSION;
        }
        if (downloadAgentVersion != null) {
            try {
                AgentAttacher.downloadAndVerifyAgent(arguments, downloadAgentVersion);
            }
            catch (Exception e) {
                logger.error(String.format("Failed to download requested agent version %s, please double-check your --download-agent-version setting.", downloadAgentVersion), (Throwable)e);
                System.exit(1);
            }
        }
        if (arguments.getAgentJar() == null) {
            logger.error("Cannot find agent jar. When using the slim jar, either the --agent-jar or the --download-agent-version arguments are required");
            System.exit(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("attacher arguments : {}", (Object)arguments);
        }
        try {
            new AgentAttacher(arguments).doAttach();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void downloadAndVerifyAgent(Arguments arguments, String downloadAgentVersion) throws Exception {
        PgpSignatureVerifier pgpSignatureVerifier;
        if (downloadAgentVersion.equalsIgnoreCase(LATEST_VERSION)) {
            downloadAgentVersion = AgentDownloader.findLatestVersion();
        }
        try {
            Path targetLibDir = AgentDownloadUtils.of(downloadAgentVersion).getTargetLibDir();
            PgpSignatureVerifierLoader verifierLoader = PgpSignatureVerifierLoader.getInstance("/bc-lib", targetLibDir, "co.elastic.apm.attach.bouncycastle.BouncyCastleVerifier");
            pgpSignatureVerifier = verifierLoader.loadPgpSignatureVerifier();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load PGP signature verifier implementation", e);
        }
        Path downloadedJarPath = new AgentDownloader(pgpSignatureVerifier).downloadAndVerifyAgent(downloadAgentVersion);
        if (!Files.isReadable(downloadedJarPath)) {
            throw new IllegalStateException(String.format("Cannot read agent jar at %s", downloadedJarPath));
        }
        arguments.setAgentJar(downloadedJarPath.toFile());
    }

    private void doAttach() {
        try {
            DiscoveryRules discoveryRules = this.arguments.getDiscoveryRules();
            if (!discoveryRules.isDiscoveryRequired() && this.arguments.isNoFork()) {
                this.attachToSpecificPidsAsCurrentUser();
            } else {
                this.discoverAndAttachLoop(discoveryRules);
            }
        }
        catch (Exception e) {
            this.logger.error("Error during attachment", (Throwable)e);
        }
    }

    private void attachToSpecificPidsAsCurrentUser() throws Exception {
        Set<String> includePids = this.arguments.getIncludePids();
        for (String includePid : includePids) {
            Properties properties = GetAgentProperties.getAgentAndSystemProperties(includePid, this.userRegistry.getCurrentUser());
            this.attach(JvmInfo.withCurrentUser(includePid, properties));
        }
    }

    private void discoverAndAttachLoop(DiscoveryRules discoveryRules) throws Exception {
        GetAgentProperties.getAgentAndSystemProperties(JvmInfo.CURRENT_PID, this.userRegistry.getCurrentUser());
        JvmDiscoverer.Compound jvmDiscoverer = new JvmDiscoverer.Compound(Arrays.asList(JvmDiscoverer.ForHotSpotVm.withDiscoveredTempDirs(this.userRegistry), new JvmDiscoverer.UsingPs(this.userRegistry)));
        while (true) {
            this.handleNewJvms(jvmDiscoverer.discoverJvms(), discoveryRules);
            if (!this.arguments.isContinuous()) break;
            Thread.sleep(1000L);
        }
    }

    static String toString(InputStream inputStream) throws IOException {
        try {
            Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private void handleNewJvms(Collection<JvmInfo> jvms, DiscoveryRules rules) {
        for (JvmInfo jvmInfo : jvms) {
            if (this.alreadySeenJvmPids.contains(jvmInfo.getPid())) continue;
            this.alreadySeenJvmPids.add(jvmInfo.getPid());
            if (jvmInfo.isCurrentVM()) continue;
            try {
                this.onJvmStart(jvmInfo, rules);
            }
            catch (Exception e) {
                this.logger.error("Unable to attach to JVM with PID = {}", (Object)jvmInfo.getPid(), (Object)e);
            }
        }
    }

    private void onJvmStart(JvmInfo jvmInfo, DiscoveryRules discoveryRules) throws Exception {
        DiscoveryRules.DiscoveryRule firstMatch = discoveryRules.firstMatch(jvmInfo, this.userRegistry);
        if (firstMatch != null) {
            if (firstMatch.getMatchingType() == DiscoveryRules.MatcherType.INCLUDE) {
                this.logger.info("Include rule {} matches for JVM {}", (Object)firstMatch, (Object)jvmInfo);
                this.onJvmMatch(jvmInfo);
            } else {
                this.logger.info("Exclude rule {} matches for JVM {}", (Object)firstMatch, (Object)jvmInfo);
            }
        } else {
            this.logger.info("No rule matches for JVM, thus excluding {}", (Object)jvmInfo);
        }
    }

    private void onJvmMatch(JvmInfo jvmInfo) throws Exception {
        if (this.arguments.isList()) {
            System.out.println(jvmInfo.toString(this.arguments.isListVmArgs()));
        } else if (this.attach(jvmInfo)) {
            this.logger.info("Done");
        } else {
            this.logger.error("Unable to attach to JVM with PID = {}", (Object)jvmInfo.getPid());
        }
    }

    private boolean attach(JvmInfo jvmInfo) throws Exception {
        Map<String, String> agentArgs = this.getAgentArgs(jvmInfo);
        this.logger.info("Attaching the Elastic APM agent to {} with arguments {}", (Object)jvmInfo, (Object)agentArgs);
        UserRegistry.User user = jvmInfo.getUser(this.userRegistry);
        if (user == null) {
            this.logger.error("Could not load user {}", (Object)jvmInfo.getUserName());
            return false;
        }
        if (!jvmInfo.isVersionSupported()) {
            this.logger.info("Cannot attach to JVM {} as the version {} is not supported.", (Object)jvmInfo, (Object)jvmInfo.getJavaVersion());
            return false;
        }
        if (jvmInfo.isAlreadyAttached()) {
            this.logger.info("The agent is already attached to JVM {}", (Object)jvmInfo);
            return false;
        }
        if (user.isCurrentUser()) {
            ElasticApmAttacher.attach(jvmInfo.getPid(), agentArgs, this.arguments.getAgentJar());
            return true;
        }
        if (user.canSwitchToUser()) {
            return this.attachAsUser(user, agentArgs, jvmInfo.getPid());
        }
        this.logger.warn("Cannot attach to {} because the current user ({}) doesn't have the permissions to switch to user {}", (Object)jvmInfo, (Object)UserRegistry.getCurrentUserName(), (Object)jvmInfo.getUserName());
        return false;
    }

    private boolean attachAsUser(UserRegistry.User user, Map<String, String> agentArgs, String pid) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--include-pid");
        args.add(pid);
        for (Map.Entry<String, String> entry : agentArgs.entrySet()) {
            args.add("--config");
            args.add(entry.getKey() + "=" + entry.getValue());
        }
        if (this.arguments.getLogLevel() != null) {
            args.add("--log-level");
            args.add(this.arguments.getLogLevel().toString());
        }
        if (this.arguments.getLogFile() != null) {
            args.add("--log-file");
            args.add(this.arguments.getLogFile());
        }
        ProcessExecutionUtil.CommandOutput output = user.executeAsUserWithCurrentClassPath(AgentAttacher.class, args);
        return output.exitedNormally();
    }

    private Map<String, String> getAgentArgs(JvmInfo jvmInfo) throws IOException, InterruptedException {
        if (this.arguments.getArgsProvider() != null) {
            LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
            for (String conf : this.getArgsProviderOutput(jvmInfo).split(";")) {
                config.put(conf.substring(0, conf.indexOf(61)), conf.substring(conf.indexOf(61) + 1));
            }
            return config;
        }
        return this.arguments.getConfig();
    }

    private String getArgsProviderOutput(JvmInfo jvmInfo) throws IOException, InterruptedException {
        Process argsProvider = new ProcessBuilder(this.arguments.getArgsProvider(), jvmInfo.getPid()).start();
        if (argsProvider.waitFor() == 0) {
            return AgentAttacher.toString(argsProvider.getInputStream());
        }
        this.logger.info("Not attaching the Elastic APM agent to {}, because the '--args-provider {}' script ended with a non-zero status code.", (Object)jvmInfo, (Object)this.arguments.argsProvider);
        throw new IllegalStateException(AgentAttacher.toString(argsProvider.getErrorStream()));
    }

    static class Arguments {
        private final DiscoveryRules rules;
        private final Set<String> includePids;
        private final Map<String, String> config;
        private final String argsProvider;
        private final boolean help;
        private final boolean list;
        private final boolean continuous;
        private final boolean noFork;
        private final Level logLevel;
        private final String logFile;
        private final boolean listVmArgs;
        private final String downloadAgentVersion;
        private File agentJar;

        private Arguments(DiscoveryRules rules, Set<String> includePids, Map<String, String> config, String argsProvider, boolean help, boolean list, boolean listVmArgs, boolean continuous, boolean noFork, Level logLevel, String logFile, String agentJarString, String downloadAgentVersion) {
            this.rules = rules;
            this.includePids = includePids;
            this.help = help;
            this.list = list;
            this.listVmArgs = listVmArgs;
            this.continuous = continuous;
            this.noFork = noFork;
            this.logLevel = logLevel;
            this.logFile = logFile;
            this.downloadAgentVersion = downloadAgentVersion;
            if (agentJarString != null) {
                this.agentJar = new File(agentJarString);
                if (!this.agentJar.exists()) {
                    throw new IllegalArgumentException(String.format("Agent jar %s does not exist", agentJarString));
                }
                if (!this.agentJar.canRead()) {
                    throw new IllegalArgumentException(String.format("Agent jar %s is not readable", agentJarString));
                }
            } else {
                this.agentJar = ElasticApmAttacher.getBundledAgentJarFile();
            }
            if (!config.isEmpty() && argsProvider != null) {
                throw new IllegalArgumentException("Providing both --config and --args-provider is illegal");
            }
            this.config = config;
            this.argsProvider = argsProvider;
        }

        static Arguments parse(String ... args) {
            DiscoveryRules rules = new DiscoveryRules();
            HashSet<String> includePids = new HashSet<String>();
            LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
            String argsProvider = null;
            boolean help = args.length == 0;
            boolean list = false;
            boolean listVmArgs = false;
            boolean continuous = false;
            boolean noFork = false;
            String currentArg = "";
            Level logLevel = Level.INFO;
            String logFile = null;
            String agentJar = null;
            String downloadedAgentVersion = null;
            block74: for (String arg : Arguments.normalize(args)) {
                if (arg.startsWith("-")) {
                    currentArg = arg;
                    switch (arg) {
                        case "-h": 
                        case "--help": {
                            help = true;
                            break;
                        }
                        case "-l": 
                        case "--list": {
                            list = true;
                            break;
                        }
                        case "-v": 
                        case "--list-vmargs": {
                            listVmArgs = true;
                            break;
                        }
                        case "-c": 
                        case "--continuous": {
                            continuous = true;
                            break;
                        }
                        case "--no-fork": {
                            noFork = true;
                            break;
                        }
                        case "--include-all": {
                            rules.includeAll();
                        }
                        case "-C": 
                        case "--config": 
                        case "-A": 
                        case "--args-provider": 
                        case "--include-pid": 
                        case "--include-main": 
                        case "--exclude-main": 
                        case "--include-user": 
                        case "--exclude-user": 
                        case "--include-vmarg": 
                        case "--include-vmargs": 
                        case "--exclude-vmarg": 
                        case "--exclude-vmargs": 
                        case "-g": 
                        case "--log-level": 
                        case "--log-file": 
                        case "--agent-jar": 
                        case "--download-agent-version": {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal argument: " + arg);
                        }
                    }
                    continue;
                }
                switch (currentArg) {
                    case "--include-main": {
                        rules.includeMain(arg);
                        continue block74;
                    }
                    case "--exclude-main": {
                        rules.excludeMain(arg);
                        continue block74;
                    }
                    case "--include-vmarg": 
                    case "--include-vmargs": {
                        rules.includeVmArgs(arg);
                        continue block74;
                    }
                    case "--exclude-vmarg": 
                    case "--exclude-vmargs": {
                        rules.excludeVmArgs(arg);
                        continue block74;
                    }
                    case "--include-user": {
                        rules.includeUser(arg);
                        continue block74;
                    }
                    case "--exclude-user": {
                        rules.excludeUser(arg);
                        continue block74;
                    }
                    case "--include-pid": {
                        rules.includePid(arg);
                        includePids.add(Objects.requireNonNull(arg));
                        continue block74;
                    }
                    case "-C": 
                    case "--config": {
                        config.put(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1));
                        continue block74;
                    }
                    case "-A": 
                    case "--args-provider": {
                        argsProvider = arg;
                        continue block74;
                    }
                    case "-g": 
                    case "--log-level": {
                        logLevel = Level.valueOf(arg);
                        continue block74;
                    }
                    case "--log-file": {
                        logFile = arg;
                        continue block74;
                    }
                    case "--agent-jar": {
                        agentJar = arg;
                        continue block74;
                    }
                    case "--download-agent-version": {
                        downloadedAgentVersion = arg;
                        continue block74;
                    }
                }
                throw new IllegalArgumentException("Illegal argument: " + arg);
            }
            return new Arguments(rules, includePids, config, argsProvider, help, list, listVmArgs, continuous, noFork, logLevel, logFile, agentJar, downloadedAgentVersion);
        }

        private static List<String> normalize(String[] args) {
            ArrayList<String> normalizedArgs = new ArrayList<String>(args.length);
            for (String arg : args) {
                if (arg.startsWith("-") && !arg.startsWith("--")) {
                    for (int i = 1; i < arg.length(); ++i) {
                        normalizedArgs.add("-" + arg.charAt(i));
                    }
                    continue;
                }
                normalizedArgs.add(arg);
            }
            return normalizedArgs;
        }

        static void printHelp(PrintStream out) {
            out.println("SYNOPSIS");
            out.println("    java -jar apm-agent-attach-cli.jar [--include-* <pattern>...] [--exclude-* <pattern>...]");
            out.println("                                       [--continuous]");
            out.println("                                       [--config <key=value>... | --args-provider <args_provider_script>]");
            out.println("                                       [--list] [--list-vmargs]");
            out.println("                                       [--log-level <level>]");
            out.println("    java -jar apm-agent-attach-cli.jar --help");
            out.println();
            out.println("DESCRIPTION");
            out.println("    Attaches the Elastic APM Java agent to all running JVMs that match the `--include-*` / `--exclude-*` discovery rules.");
            out.println("    For every running JVM, the discovery rules are evaluated in the order they are provided.");
            out.println("    The first matching rule determines the outcome.");
            out.println("    * If the first matching rules is an exclude, the agent will not be attached.");
            out.println("    * If the first matching rules is an include, the agent will be attached.");
            out.println("    * If no rule matches, the agent will not be attached.");
            out.println();
            out.println("OPTIONS");
            out.println("    -l, --list");
            out.println("        This lets you do a dry run of the include/exclude discovery rules.");
            out.println("        Instead of attaching to matching JVMs, the programm will print JVMs that match the include/exclude discovery rules.");
            out.println("        Similar to `jps -l`, the output includes the PID and the main class name or the path to the jar file.");
            out.println();
            out.println("    -v, --list-vmargs");
            out.println("        When listing running JVMs via `--list`, include the arguments passed to the JVM.");
            out.println("        Provides an output similar to `jps -lv`.");
            out.println("        Note: The JVM arguments may contain sensitive information, such as passwords provided via system properties.");
            out.println();
            out.println("    -c, --continuous");
            out.println("        If provided, this program continuously runs and attaches to all running and starting JVMs which match the --exclude and --include filters.");
            out.println();
            out.println("    --no-fork");
            out.println("        By default, when the attacher program is ran by user A and the target process is ran by user B, ");
            out.println("        the attacher will attempt to start another process as user B. ");
            out.println("        If this configuration option is provided, the attacher will not fork. Instead, it will attempt to attach directly as the current user.");
            out.println();
            out.println("    --include-all");
            out.println("        Includes all JVMs for attachment.");
            out.println();
            out.println("    --include-pid <pid>...");
            out.println("        A list of PIDs to include.");
            out.println();
            out.println("    --include-main/--exclude-main <pattern>");
            out.println("        A regular expression of fully qualified main class names or paths to JARs of applications the java agent should be attached to.");
            out.println("        Performs a partial match so that `foo` matches `/bin/foo.jar`.");
            out.println();
            out.println("    --include-vmarg/--exclude-vmarg <pattern>");
            out.println("        A regular expression that is matched against the arguments passed to the JVM, such as system properties.");
            out.println("        Performs a partial match so that `attach=true` matches the system property `-Dattach=true`.");
            out.println();
            out.println("    --include-user/--exclude-user <user>");
            out.println("        A username that is matched against the operating system user that run the JVM.");
            out.println("        For included users, make sure that the user this program is running under is either the same user or has permissions to switch to the user that runs the target JVM.");
            out.println();
            out.println("    -C --config <key=value>...");
            out.println("        This repeatable option sets one agent configuration option.");
            out.println("        Example: --config server_url=http://localhost:8200.");
            out.println();
            out.println("    -A, --args-provider <args_provider_script>");
            out.println("        The name of a program which is called when a new JVM starts up.");
            out.println("        The program gets the pid as an argument");
            out.println("        and returns an arg string which is used to configure the agent on the attached JVM (agentArguments of agentmain).");
            out.println("        When returning a non-zero status code from this program, the agent will not be attached to the starting JVM.");
            out.println("        The syntax of the arguments is 'key1=value1;key2=value1,value2'.");
            out.println("        Note: this option can not be used in conjunction with --include-pid and --args.");
            out.println();
            out.println("    -g, --log-level <off|fatal|error|warn|info|debug|trace|all>");
            out.println("        Configures the verbosity of the logs that are sent to stdout with an ECS JSON format.");
            out.println();
            out.println("    --log-file <file>");
            out.println("        To log into a file instead of the console, specify a path to a file that this program should log into.");
            out.println("        The log file rolls over once the file has reached a size of 10MB.");
            out.println("        One history file will be kept with the name `${logFile}.1`.");
            out.println();
            out.println("    --agent-jar <file>");
            out.println("        Instead of the bundled agent jar, attach the provided agent to the target JVMs.");
            out.println();
            out.println("    --download-agent-version <agent-version>");
            out.println("        Instead of the bundled agent jar, download and attach the specified agent version from maven.");
            out.println("        <agent-version> can be either the explicit version (for example: `1.15.0`) or `latest`.");
        }

        Map<String, String> getConfig() {
            return this.config;
        }

        String getArgsProvider() {
            return this.argsProvider;
        }

        boolean isHelp() {
            return this.help;
        }

        boolean isList() {
            return this.list;
        }

        boolean isContinuous() {
            return this.continuous;
        }

        boolean isNoFork() {
            return this.noFork;
        }

        public DiscoveryRules getDiscoveryRules() {
            return this.rules;
        }

        public Set<String> getIncludePids() {
            return this.includePids;
        }

        public boolean isListVmArgs() {
            return this.listVmArgs;
        }

        public String getLogFile() {
            return this.logFile;
        }

        public boolean isLogToConsole() {
            return this.logFile == null;
        }

        public String getDownloadAgentVersion() {
            return this.downloadAgentVersion;
        }

        public void setAgentJar(File agentJar) {
            this.agentJar = agentJar;
        }

        public File getAgentJar() {
            return this.agentJar;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public String toString() {
            return "Arguments{rules=" + this.rules + ", config=" + this.config + ", argsProvider='" + this.argsProvider + '\'' + ", help=" + this.help + ", list=" + this.list + ", continuous=" + this.continuous + ", logLevel=" + this.logLevel + ", logFile='" + this.logFile + '\'' + ", listVmArgs=" + this.listVmArgs + ", agentJar=" + this.agentJar + '}';
        }
    }
}

