/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j2;

import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;

interface MultiFormatHandler {
    public void formatJsonTo(MultiformatMessage var1, StringBuilder var2);

    public static enum ForLegacyLog4j implements MultiFormatHandler
    {
        INSTANCE;

        private static final String[] JSON_FORMAT;

        @Override
        public void formatJsonTo(MultiformatMessage message, StringBuilder builder) {
            builder.append(message.getFormattedMessage(JSON_FORMAT));
        }

        static {
            JSON_FORMAT = new String[]{"JSON"};
        }
    }

    public static enum MultiFormatStringBuilderFormattableAware implements MultiFormatHandler
    {
        INSTANCE;

        private static final String[] JSON_FORMAT;

        @Override
        public void formatJsonTo(MultiformatMessage message, StringBuilder builder) {
            if (message instanceof MultiFormatStringBuilderFormattable) {
                ((MultiFormatStringBuilderFormattable)message).formatTo(JSON_FORMAT, builder);
            } else {
                builder.append(message.getFormattedMessage(JSON_FORMAT));
            }
        }

        static {
            JSON_FORMAT = new String[]{"JSON"};
        }
    }

    public static class Resolver {
        static MultiFormatHandler resolve() {
            try {
                Class.forName("org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable");
                return (MultiFormatHandler)Class.forName("co.elastic.logging.log4j2.MultiFormatHandler$MultiFormatStringBuilderFormattableAware").getEnumConstants()[0];
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            return ForLegacyLog4j.INSTANCE;
        }
    }
}

