/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.JvmInfo;
import co.elastic.apm.attach.UserRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

class DiscoveryRules {
    private final List<DiscoveryRule> discoveryRules = new ArrayList<DiscoveryRule>();

    DiscoveryRules() {
    }

    private void include(Matcher matcher) {
        this.discoveryRules.add(DiscoveryRule.include(matcher));
    }

    private void exclude(Matcher matcher) {
        this.discoveryRules.add(DiscoveryRule.exclude(matcher));
    }

    public void includeAll() {
        this.include(ConstantMatcher.ALL);
    }

    public void includeMain(String pattern) {
        this.include(new MainClassMatcher(Pattern.compile(pattern)));
    }

    public void excludeMain(String pattern) {
        this.exclude(new MainClassMatcher(Pattern.compile(pattern)));
    }

    public void includeVmArgs(String pattern) {
        this.include(new VmArgsMatcher(Pattern.compile(pattern)));
    }

    public void excludeVmArgs(String pattern) {
        this.exclude(new VmArgsMatcher(Pattern.compile(pattern)));
    }

    public void includePid(String pid) {
        this.include(new PidMatcher(pid));
    }

    public void excludePid(String pid) {
        this.exclude(new PidMatcher(pid));
    }

    public void includeUser(String user) {
        this.include(new UserMatcher(user));
    }

    public void excludeUser(String user) {
        this.exclude(new UserMatcher(user));
    }

    public boolean isMatching(JvmInfo vm, UserRegistry userRegistry) {
        DiscoveryRule firstMatch = this.firstMatch(vm, userRegistry);
        return firstMatch != null && firstMatch.getMatchingType() == MatcherType.INCLUDE;
    }

    public DiscoveryRule firstMatch(JvmInfo vm, UserRegistry userRegistry) {
        for (DiscoveryRule discoveryRule : this.discoveryRules) {
            if (!discoveryRule.matches(vm, userRegistry)) continue;
            return discoveryRule;
        }
        return null;
    }

    public Collection<DiscoveryRule> getMatcherRules() {
        return new ArrayList<DiscoveryRule>(this.discoveryRules);
    }

    public Collection<DiscoveryRule> getIncludeRules() {
        ArrayList<DiscoveryRule> includeRules = new ArrayList<DiscoveryRule>(this.discoveryRules);
        Iterator<DiscoveryRule> iterator = includeRules.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().matcherType == MatcherType.INCLUDE) continue;
            iterator.remove();
        }
        return includeRules;
    }

    public Collection<DiscoveryRule> getExcludeRules() {
        ArrayList<DiscoveryRule> excludeRules = new ArrayList<DiscoveryRule>(this.discoveryRules);
        Iterator<DiscoveryRule> iterator = excludeRules.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().matcherType == MatcherType.EXCLUDE) continue;
            iterator.remove();
        }
        return excludeRules;
    }

    private static class UserMatcher
    implements Matcher {
        private final String user;

        private UserMatcher(String user) {
            this.user = user;
        }

        @Override
        public boolean matches(JvmInfo vm, UserRegistry userRegistry) {
            return this.user.equals(vm.getUserName());
        }

        public String toString() {
            return "user(" + this.user + ")";
        }
    }

    private static class PidMatcher
    implements Matcher {
        private final String pid;

        private PidMatcher(String pid) {
            this.pid = Objects.requireNonNull(pid);
        }

        @Override
        public boolean matches(JvmInfo vm, UserRegistry userRegistry) {
            return this.pid.equals(vm.getPid());
        }

        public String toString() {
            return "pid(" + this.pid + ")";
        }
    }

    private static class VmArgsMatcher
    implements Matcher {
        private final Pattern matcher;

        private VmArgsMatcher(Pattern matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean matches(JvmInfo vm, UserRegistry userRegistry) {
            try {
                String vmArgs = vm.getVmArgs();
                return vmArgs != null && this.matcher.matcher(vmArgs).find();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "vmArgs(" + this.matcher + ")";
        }
    }

    private static class MainClassMatcher
    implements Matcher {
        private final Pattern matcher;

        private MainClassMatcher(Pattern matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean matches(JvmInfo vm, UserRegistry userRegistry) {
            try {
                String mainClass = vm.getMainClass();
                return mainClass != null && this.matcher.matcher(mainClass).find();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "main(" + this.matcher + ")";
        }
    }

    private static enum ConstantMatcher implements Matcher
    {
        ALL(true),
        NONE(false);

        private final boolean matches;

        private ConstantMatcher(boolean matches) {
            this.matches = matches;
        }

        @Override
        public boolean matches(JvmInfo vm, UserRegistry userRegistry) {
            return this.matches;
        }
    }

    static interface Matcher {
        public boolean matches(JvmInfo var1, UserRegistry var2);
    }

    public static enum MatcherType {
        INCLUDE,
        EXCLUDE;

    }

    public static class DiscoveryRule
    implements Matcher {
        private final Matcher matcher;
        private final MatcherType matcherType;

        private DiscoveryRule(Matcher matcher, MatcherType matcherType) {
            this.matcher = matcher;
            this.matcherType = matcherType;
        }

        public static DiscoveryRule include(Matcher matcher) {
            return new DiscoveryRule(matcher, MatcherType.INCLUDE);
        }

        public static DiscoveryRule exclude(Matcher matcher) {
            return new DiscoveryRule(matcher, MatcherType.EXCLUDE);
        }

        public MatcherType getMatchingType() {
            return this.matcherType;
        }

        @Override
        public boolean matches(JvmInfo vm, UserRegistry userRegistry) {
            return this.matcher.matches(vm, userRegistry);
        }

        public String toString() {
            return this.matcherType == MatcherType.INCLUDE ? "include(" + this.matcher + ')' : "exclude(" + this.matcher + ')';
        }
    }
}

