/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.api;

import co.elastic.apm.api.Span;
import co.elastic.apm.api.Tracer;
import co.elastic.apm.api.Transaction;
import javax.annotation.Nonnull;

public class ElasticApm
implements Tracer {
    private static final ElasticApm INSTANCE = new ElasticApm();
    private Tracer tracer = NoopTracer.INSTANCE;

    private ElasticApm() {
    }

    @Nonnull
    public static ElasticApm get() {
        return INSTANCE;
    }

    void register(Tracer tracer) {
        ElasticApm.INSTANCE.tracer = tracer;
    }

    void unregister() {
        ElasticApm.INSTANCE.tracer = NoopTracer.INSTANCE;
    }

    @Override
    @Nonnull
    public Transaction startTransaction() {
        return this.tracer.startTransaction();
    }

    @Override
    @Nonnull
    public Transaction currentTransaction() {
        Transaction transaction = this.tracer.currentTransaction();
        return transaction != null ? transaction : NoopTracer.NoopTransaction.INSTANCE;
    }

    @Override
    @Nonnull
    public Span currentSpan() {
        Span span = this.tracer.currentSpan();
        return span != null ? span : NoopTracer.NoopSpan.INSTANCE;
    }

    @Override
    @Nonnull
    public Span startSpan() {
        return this.tracer.startSpan();
    }

    @Override
    public void captureException(@Nonnull Exception e) {
        this.tracer.captureException(e);
    }

    static enum NoopTracer implements Tracer
    {
        INSTANCE;


        @Override
        @Nonnull
        public Transaction startTransaction() {
            return NoopTransaction.INSTANCE;
        }

        @Override
        public Transaction currentTransaction() {
            return NoopTransaction.INSTANCE;
        }

        @Override
        public Span currentSpan() {
            return NoopSpan.INSTANCE;
        }

        @Override
        @Nonnull
        public Span startSpan() {
            return NoopSpan.INSTANCE;
        }

        @Override
        public void captureException(@Nonnull Exception e) {
        }

        static enum NoopSpan implements Span
        {
            INSTANCE;


            @Override
            public void setName(String name) {
            }

            @Override
            public void setType(String type) {
            }

            @Override
            public void end() {
            }

            @Override
            public void close() {
            }
        }

        static enum NoopTransaction implements Transaction
        {
            INSTANCE;


            @Override
            public void setName(String name) {
            }

            @Override
            public void setType(String type) {
            }

            @Override
            public void addTag(String key, String value) {
            }

            @Override
            public void setUser(String id, String email, String username) {
            }

            @Override
            public void end() {
            }

            @Override
            public void close() {
            }
        }
    }
}

